/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.common.template;

import io.vertx.core.Vertx;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.common.template.impl.TemplateHolder;
import java.util.Objects;

public abstract class CachingTemplateEngine<T>
implements TemplateEngine {
    private final LocalMap<String, TemplateHolder<T>> cache;
    protected String extension;

    protected CachingTemplateEngine(Vertx vertx, String ext) {
        this.cache = !WebEnvironment.development() ? vertx.sharedData().getLocalMap("__vertx.web.template.cache") : null;
        Objects.requireNonNull(ext);
        this.extension = ext.charAt(0) == '.' ? ext : "." + ext;
    }

    public TemplateHolder<T> getTemplate(String filename) {
        if (this.cache != null) {
            return (TemplateHolder)this.cache.get((Object)filename);
        }
        return null;
    }

    public TemplateHolder<T> putTemplate(String filename, TemplateHolder<T> templateHolder) {
        if (this.cache != null) {
            return (TemplateHolder)this.cache.put((Object)filename, templateHolder);
        }
        return null;
    }

    protected String adjustLocation(String location) {
        if (this.extension != null && !location.endsWith(this.extension)) {
            location = location + this.extension;
        }
        return location;
    }
}

