/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.impl.cache.UserAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Vary {
    private final MultiMap requestHeaders;
    private final MultiMap responseHeaders;
    private final Set<CharSequence> variations;

    public Vary(MultiMap requestHeaders, MultiMap responseHeaders) {
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.variations = this.parseHeaders(responseHeaders);
    }

    public boolean matchesRequest(HttpRequest<?> request) {
        return this.variations.stream().allMatch(variation -> this.variationMatches((CharSequence)variation, request));
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>(this.variations.size());
        for (CharSequence variation : this.variations) {
            parts.addAll(this.normalizeValues(this.requestHeaders.getAll(variation)));
        }
        return parts.stream().sorted().collect(Collectors.joining(","));
    }

    private boolean variationMatches(CharSequence variation, HttpRequest<?> request) {
        if (HttpHeaders.USER_AGENT.equals(variation)) {
            return this.isUserAgentMatch(request);
        }
        if (HttpHeaders.CONTENT_ENCODING.equals(variation)) {
            return this.isEncodingMatch(request);
        }
        if (HttpHeaders.ACCEPT_ENCODING.equals(variation)) {
            return this.isEncodingMatch(request);
        }
        return this.isExactMatch(variation, request);
    }

    private boolean isUserAgentMatch(HttpRequest<?> request) {
        UserAgent original = UserAgent.parse(this.requestHeaders);
        UserAgent current = UserAgent.parse(request.headers());
        return original.equals(current);
    }

    private boolean isEncodingMatch(HttpRequest<?> request) {
        Set<String> req = this.normalizeValues(request.headers().getAll(HttpHeaders.ACCEPT_ENCODING));
        Set<String> res = this.normalizeValues(this.responseHeaders.getAll(HttpHeaders.CONTENT_ENCODING));
        HashSet<String> intersection = new HashSet<String>(req);
        intersection.retainAll(res);
        return !intersection.isEmpty();
    }

    private boolean isExactMatch(CharSequence variation, HttpRequest<?> request) {
        Set<String> a = this.normalizeValues(request.headers().getAll(variation));
        Set<String> b = this.normalizeValues(this.requestHeaders.getAll(variation));
        return a.equals(b);
    }

    private Set<String> normalizeValues(List<String> values) {
        return values.stream().flatMap(v -> Arrays.stream(v.split(","))).map(v -> v.trim().toLowerCase()).collect(Collectors.toSet());
    }

    private Set<CharSequence> parseHeaders(MultiMap headers) {
        List varyHeaders = headers.getAll(HttpHeaders.VARY);
        HashSet<CharSequence> parsed = new HashSet<CharSequence>(varyHeaders.size());
        varyHeaders.forEach(names -> {
            for (String name : names.split(",")) {
                parsed.add(HttpHeaders.createOptimized((String)name.trim().toLowerCase()));
            }
        });
        return parsed;
    }
}

