/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class AsyncResultMaybe<T>
extends Maybe<T> {
    private final Consumer<Handler<AsyncResult<T>>> subscriptionConsumer;

    public static <T> Maybe<T> toMaybe(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly(new AsyncResultMaybe<T>(subscriptionConsumer));
    }

    public AsyncResultMaybe(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        this.subscriptionConsumer = subscriptionConsumer;
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.subscriptionConsumer.accept(ar -> {
                        block9: {
                            if (!disposed.getAndSet(true)) {
                                if (ar.succeeded()) {
                                    try {
                                        Object val = ar.result();
                                        if (val != null) {
                                            observer.onSuccess(val);
                                            break block9;
                                        }
                                        observer.onComplete();
                                    }
                                    catch (Throwable t) {
                                        Exceptions.throwIfFatal((Throwable)t);
                                        RxJavaPlugins.onError((Throwable)t);
                                    }
                                } else if (ar.failed()) {
                                    try {
                                        observer.onError(ar.cause());
                                    }
                                    catch (Throwable t) {
                                        Exceptions.throwIfFatal((Throwable)t);
                                        RxJavaPlugins.onError((Throwable)t);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal((Throwable)t);
                        RxJavaPlugins.onError((Throwable)t);
                    }
                }
            }
        }
    }
}

