/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.StartTLSOptions;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@DataObject
public class MailConfig {
    private static final LoginOption DEFAULT_LOGIN = LoginOption.NONE;
    private static final StartTLSOptions DEFAULT_TLS = StartTLSOptions.OPTIONAL;
    private static final int DEFAULT_PORT = 25;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final boolean DEFAULT_SSL = false;
    private static final boolean DEFAULT_TRUST_ALL = false;
    private static final Set<String> DEFAULT_SECURE_TRANSPORT_PROTOCOLS = new LinkedHashSet<String>(NetClientOptions.DEFAULT_ENABLED_SECURE_TRANSPORT_PROTOCOLS);
    private static final boolean DEFAULT_ALLOW_RCPT_ERRORS = false;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_DISABLE_ESMTP = false;
    private String hostname = "localhost";
    private int port = 25;
    private StartTLSOptions starttls = DEFAULT_TLS;
    private LoginOption login = DEFAULT_LOGIN;
    private String authMethods;
    private String username;
    private String password;
    private boolean ssl = false;
    private boolean trustAll = false;
    private Set<String> enabledSecureTransportProtocols = DEFAULT_SECURE_TRANSPORT_PROTOCOLS;
    private String keyStore;
    private String keyStorePassword;
    private String ownHostname;
    private int maxPoolSize = 10;
    private boolean keepAlive = true;
    private boolean allowRcptErrors = false;
    private boolean disableEsmtp = false;

    public MailConfig() {
    }

    public MailConfig(String hostname) {
        this();
        this.hostname = hostname;
    }

    public MailConfig(String hostname, int port) {
        this();
        this.hostname = hostname;
        this.port = port;
    }

    public MailConfig(String hostname, int port, StartTLSOptions starttls, LoginOption login) {
        this(hostname, port);
        this.starttls = starttls;
        this.login = login;
    }

    public MailConfig(MailConfig other) {
        this.hostname = other.hostname;
        this.port = other.port;
        this.starttls = other.starttls;
        this.login = other.login;
        this.username = other.username;
        this.password = other.password;
        this.ssl = other.ssl;
        this.trustAll = other.trustAll;
        this.keyStore = other.keyStore;
        this.keyStorePassword = other.keyStorePassword;
        this.authMethods = other.authMethods;
        this.ownHostname = other.ownHostname;
        this.maxPoolSize = other.maxPoolSize;
        this.keepAlive = other.keepAlive;
        this.allowRcptErrors = other.allowRcptErrors;
        this.disableEsmtp = other.disableEsmtp;
    }

    public MailConfig(JsonObject config) {
        this.hostname = config.getString("hostname", DEFAULT_HOST);
        this.port = config.getInteger("port", Integer.valueOf(25));
        String starttlsOption = config.getString("starttls");
        this.starttls = starttlsOption != null ? StartTLSOptions.valueOf(starttlsOption.toUpperCase(Locale.ENGLISH)) : DEFAULT_TLS;
        String loginOption = config.getString("login");
        this.login = loginOption != null ? LoginOption.valueOf(loginOption.toUpperCase(Locale.ENGLISH)) : DEFAULT_LOGIN;
        this.username = config.getString("username");
        this.password = config.getString("password");
        this.ssl = config.getBoolean("ssl", Boolean.valueOf(false));
        this.trustAll = config.getBoolean("trustAll", Boolean.valueOf(false));
        this.keyStore = config.getString("keyStore");
        this.keyStorePassword = config.getString("keyStorePassword");
        this.authMethods = config.getString("authMethods");
        this.ownHostname = config.getString("ownHostname");
        this.maxPoolSize = config.getInteger("maxPoolSize", Integer.valueOf(10));
        this.keepAlive = config.getBoolean("keepAlive", Boolean.valueOf(true));
        this.allowRcptErrors = config.getBoolean("allowRcptErrors", Boolean.valueOf(false));
    }

    public String getHostname() {
        return this.hostname;
    }

    public MailConfig setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MailConfig setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be >=0 && <= 65535");
        }
        this.port = port;
        return this;
    }

    public StartTLSOptions getStarttls() {
        return this.starttls;
    }

    public MailConfig setStarttls(StartTLSOptions starttls) {
        this.starttls = starttls;
        return this;
    }

    public LoginOption getLogin() {
        return this.login;
    }

    public MailConfig setLogin(LoginOption login) {
        this.login = login;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public MailConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MailConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public MailConfig setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public Set<String> getEnabledSecureTransportProtocols() {
        return new LinkedHashSet<String>(this.enabledSecureTransportProtocols);
    }

    public MailConfig setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        this.enabledSecureTransportProtocols = enabledSecureTransportProtocols;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public MailConfig setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public MailConfig setKeyStore(String keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public MailConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getAuthMethods() {
        return this.authMethods;
    }

    public MailConfig setAuthMethods(String authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public String getOwnHostname() {
        return this.ownHostname;
    }

    public MailConfig setOwnHostname(String ownHostname) {
        this.ownHostname = ownHostname;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public MailConfig setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be > 0");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public MailConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isAllowRcptErrors() {
        return this.allowRcptErrors;
    }

    public MailConfig setAllowRcptErrors(boolean allowRcptErrors) {
        this.allowRcptErrors = allowRcptErrors;
        return this;
    }

    public boolean isDisableEsmtp() {
        return this.disableEsmtp;
    }

    public MailConfig setDisableEsmtp(boolean disableEsmtp) {
        this.disableEsmtp = disableEsmtp;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.hostname != null) {
            json.put("hostname", this.hostname);
        }
        json.put("port", Integer.valueOf(this.port));
        if (this.starttls != null) {
            json.put("starttls", (Enum)this.starttls);
        }
        if (this.login != null) {
            json.put("login", (Enum)this.login);
        }
        if (this.username != null) {
            json.put("username", this.username);
        }
        if (this.password != null) {
            json.put("password", this.password);
        }
        if (this.ssl) {
            json.put("ssl", Boolean.valueOf(true));
        }
        if (this.trustAll) {
            json.put("trustAll", Boolean.valueOf(true));
        }
        if (this.keyStore != null) {
            json.put("keyStore", this.keyStore);
        }
        if (this.keyStorePassword != null) {
            json.put("keyStorePassword", this.keyStorePassword);
        }
        if (this.authMethods != null) {
            json.put("authMethods", this.authMethods);
        }
        if (this.ownHostname != null) {
            json.put("ownHostname", this.ownHostname);
        }
        json.put("maxPoolSize", Integer.valueOf(this.maxPoolSize));
        if (!this.keepAlive) {
            json.put("keepAlive", Boolean.valueOf(false));
        }
        if (this.allowRcptErrors) {
            json.put("allowRcptErrors", Boolean.valueOf(true));
        }
        if (this.disableEsmtp) {
            json.put("disableEsmtp", Boolean.valueOf(true));
        }
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(new Object[]{this.hostname, this.port, this.starttls, this.login, this.username, this.password, this.ssl, this.trustAll, this.keyStore, this.keyStorePassword, this.authMethods, this.ownHostname, this.maxPoolSize, this.keepAlive, this.allowRcptErrors, this.disableEsmtp});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailConfig)) {
            return false;
        }
        MailConfig config = (MailConfig)o;
        return this.getList().equals(config.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }
}

