/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.cpu;

import io.vertx.core.impl.launcher.commands.ExecUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.AccessController;

public class CpuCoreSensor {
    private static final String CPUS_ALLOWED = "Cpus_allowed:";
    private static final byte[] BITS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private static final Charset ASCII = Charset.forName("US-ASCII");

    public static int availableProcessors() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> CpuCoreSensor.determineProcessors());
        }
        return CpuCoreSensor.determineProcessors();
    }

    private static int determineProcessors() {
        int fromJava = Runtime.getRuntime().availableProcessors();
        int fromProcFile = 0;
        if (!ExecUtils.isLinux()) {
            return fromJava;
        }
        try {
            fromProcFile = CpuCoreSensor.readCPUMask(new File("/proc/self/status"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fromProcFile > 0 ? Math.min(fromJava, fromProcFile) : fromJava;
    }

    protected static int readCPUMask(File file) throws IOException {
        if (file == null || !file.exists()) {
            return -1;
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader inputReader = new InputStreamReader((InputStream)stream, ASCII);
        try (BufferedReader reader = new BufferedReader(inputReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                int start;
                if (!line.startsWith(CPUS_ALLOWED)) continue;
                int count = 0;
                for (int i = start = CPUS_ALLOWED.length(); i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        count += BITS[ch - 48];
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        count += BITS[ch - 97 + 10];
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') continue;
                    count += BITS[ch - 65 + 10];
                }
                int n = count;
                return n;
            }
        }
        return -1;
    }
}

