/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.transport.EpollTransport;
import io.vertx.core.net.impl.transport.KQueueTransport;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;

public class Transport {
    public static final int ACCEPTOR_EVENT_LOOP_GROUP = 0;
    public static final int IO_EVENT_LOOP_GROUP = 1;
    public static Transport JDK = new Transport();

    public static Transport nativeTransport() {
        Transport transport = null;
        try {
            EpollTransport epoll = new EpollTransport();
            if (((Transport)epoll).isAvailable()) {
                return epoll;
            }
            transport = epoll;
        }
        catch (Throwable epoll) {
            // empty catch block
        }
        try {
            KQueueTransport kqueue = new KQueueTransport();
            if (((Transport)kqueue).isAvailable()) {
                return kqueue;
            }
            if (transport == null) {
                transport = kqueue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return transport;
    }

    public static Transport transport(boolean preferNative) {
        if (preferNative) {
            Transport nativeTransport = Transport.nativeTransport();
            if (nativeTransport != null && nativeTransport.isAvailable()) {
                return nativeTransport;
            }
            return JDK;
        }
        return JDK;
    }

    protected Transport() {
    }

    public boolean isAvailable() {
        return true;
    }

    public Throwable unavailabilityCause() {
        return null;
    }

    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            throw new IllegalArgumentException("Domain socket not supported by JDK transport");
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return new SocketAddressImpl((InetSocketAddress)address);
        }
        return null;
    }

    ChannelOption<?> channelOption(String name) {
        return null;
    }

    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioSocketChannel::new;
    }

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel::new;
    }

    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setAllocator((ByteBufAllocator)PartialPooledByteBufAllocator.INSTANCE);
        if (options.getSendBufferSize() != -1) {
            channel.config().setSendBufferSize(options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            channel.config().setReceiveBufferSize(options.getReceiveBufferSize());
            channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        channel.config().setOption(ChannelOption.SO_REUSEADDR, (Object)options.isReuseAddress());
        if (options.getTrafficClass() != -1) {
            channel.config().setTrafficClass(options.getTrafficClass());
        }
        channel.config().setBroadcast(options.isBroadcast());
        if (this == JDK) {
            channel.config().setLoopbackModeDisabled(options.isLoopbackModeDisabled());
            if (options.getMulticastTimeToLive() != -1) {
                channel.config().setTimeToLive(options.getMulticastTimeToLive());
            }
            if (options.getMulticastNetworkInterface() != null) {
                try {
                    channel.config().setNetworkInterface(NetworkInterface.getByName(options.getMulticastNetworkInterface()));
                }
                catch (SocketException e) {
                    throw new IllegalArgumentException("Could not find network interface with name " + options.getMulticastNetworkInterface());
                }
            }
        }
    }

    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)options.isReuseAddress());
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
        }
        if (options.getLocalAddress() != null) {
            bootstrap.localAddress(options.getLocalAddress(), 0);
        }
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
    }

    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)options.isReuseAddress());
        if (!domainSocket) {
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        }
        if (options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        if (options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)options.getAcceptBacklog());
        }
    }
}

