/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.UndertowClientMessages;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;

public class UndertowClientMessages_$bundle
implements UndertowClientMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final UndertowClientMessages_$bundle INSTANCE = new UndertowClientMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String connectionClosed = "UT001000: Connection closed";
    private static final String requestAlreadyWritten = "UT001001: Request already written";
    private static final String failedToUpgradeChannel = "UT001020: Failed to upgrade channel due to response %s (%s)";
    private static final String illegalContentLength = "UT001030: invalid content length %d";
    private static final String unknownScheme = "UT001031: Unknown scheme in URI %s";
    private static final String unknownTransferEncoding = "UT001032: Unknown transfer encoding %s";
    private static final String invalidConnectionState = "UT001033: Invalid connection state";
    private static final String unknownAjpMessageType = "UT001034: Unknown AJP packet type %s";
    private static final String unknownMethod = "UT001035: Unknown method type for AJP request %s";
    private static final String dataStillRemainingInChunk = "UT001036: Data still remaining in chunk %s";
    private static final String wrongMagicNumber = "UT001037: Wrong magic number, expected %s, actual %s";
    private static final String receivedInvalidChunk = "UT001038: Received invalid AJP chunk %s with response already complete";

    protected UndertowClientMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String connectionClosed$str() {
        return connectionClosed;
    }

    @Override
    public final String connectionClosed() {
        return String.format(this.getLoggingLocale(), this.connectionClosed$str(), new Object[0]);
    }

    protected String requestAlreadyWritten$str() {
        return requestAlreadyWritten;
    }

    @Override
    public final IllegalStateException requestAlreadyWritten() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.requestAlreadyWritten$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToUpgradeChannel$str() {
        return failedToUpgradeChannel;
    }

    @Override
    public final String failedToUpgradeChannel(int responseCode, String reason) {
        return String.format(this.getLoggingLocale(), this.failedToUpgradeChannel$str(), responseCode, reason);
    }

    protected String illegalContentLength$str() {
        return illegalContentLength;
    }

    @Override
    public final IllegalArgumentException illegalContentLength(long length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalContentLength$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownScheme$str() {
        return unknownScheme;
    }

    @Override
    public final IllegalArgumentException unknownScheme(URI uri) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownScheme$str(), uri));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownTransferEncoding$str() {
        return unknownTransferEncoding;
    }

    @Override
    public final IOException unknownTransferEncoding(String transferEncodingString) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unknownTransferEncoding$str(), transferEncodingString));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnectionState$str() {
        return invalidConnectionState;
    }

    @Override
    public final IOException invalidConnectionState() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidConnectionState$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAjpMessageType$str() {
        return unknownAjpMessageType;
    }

    @Override
    public final IOException unknownAjpMessageType(byte packetType) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unknownAjpMessageType$str(), packetType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownMethod$str() {
        return unknownMethod;
    }

    @Override
    public final IOException unknownMethod(HttpString method) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unknownMethod$str(), method));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dataStillRemainingInChunk$str() {
        return dataStillRemainingInChunk;
    }

    @Override
    public final IOException dataStillRemainingInChunk(long remaining) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.dataStillRemainingInChunk$str(), remaining));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrongMagicNumber$str() {
        return wrongMagicNumber;
    }

    @Override
    public final IOException wrongMagicNumber(String expected, String actual) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.wrongMagicNumber$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String receivedInvalidChunk$str() {
        return receivedInvalidChunk;
    }

    @Override
    public final IOException receivedInvalidChunk(byte prefix) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.receivedInvalidChunk$str(), prefix));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

