/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = -1L;
    private Function<Object, String> function = Object::toString;

    public SortedProperties() {
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        ArrayList<Object> keys = Collections.list(super.keys());
        List<Object> sortedKeys = this.sort(keys);
        return Collections.enumeration(sortedKeys);
    }

    @Override
    public Set<String> stringPropertyNames() {
        Set<String> stringPropertyNames = super.stringPropertyNames();
        List<String> sortedStringPropertyNames = this.sort(stringPropertyNames);
        return new LinkedHashSet<String>(sortedStringPropertyNames);
    }

    public void setFunction(Function<?, String> function) {
        this.function = Objects.requireNonNull(function);
    }

    private <O> List<O> sort(Collection<O> collection) {
        List<Object> list = collection instanceof List ? (List<Object>)collection : new ArrayList<O>(collection);
        list.sort(Comparator.comparing(this.function));
        return list;
    }
}

