/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.function.Predicate;

public class Numbers {
    public static final Predicate<Integer> NULL_OR_ZERO_INTEGER = input -> input == null || input == 0;
    private static final MathContext mc1Digit = new MathContext(1);
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_ONE_DIGIT = input -> input == null || (double)Math.abs(Numbers.roundOneDigit(input).floatValue()) < 0.1;
    private static final MathContext mc2Digits = new MathContext(2);
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_TWO_DIGITS = input -> input == null || (double)Math.abs(Numbers.roundTwoDigits(input).floatValue()) < 0.01;
    private static final MathContext mc3Digits = new MathContext(3);
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_THREE_DIGITS = input -> input == null || (double)Math.abs(Numbers.roundThreeDigits(input).floatValue()) < 0.001;
    private static final MathContext mc4Digits = new MathContext(4);
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_FOUR_DIGITS = input -> input == null || (double)Math.abs(Numbers.roundFourDigits(input).floatValue()) < 1.0E-4;
    private static final MathContext mc5Digits = new MathContext(5);
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_FIVE_DIGITS = input -> input == null || (double)Math.abs(Numbers.roundFiveDigits(input).floatValue()) < 1.0E-5;

    public static int[] divideAndEnsureSum(int divisor, int dividend) {
        if (dividend == 0) {
            return null;
        }
        int quotient = (int)((double)divisor) / dividend;
        int[] result = new int[dividend];
        Arrays.fill(result, quotient);
        int i = 0;
        for (int sum = quotient * dividend; sum != divisor && i < dividend; ++sum) {
            int n = i++;
            result[n] = result[n] + 1;
        }
        return result;
    }

    public static Float roundOneDigit(Float number) {
        return Numbers.round(number, mc1Digit);
    }

    public static Float roundTwoDigits(Float number) {
        return Numbers.round(number, mc2Digits);
    }

    public static Float roundThreeDigits(Float number) {
        return Numbers.round(number, mc3Digits);
    }

    public static Float roundFourDigits(Float number) {
        return Numbers.round(number, mc4Digits);
    }

    private static Float roundFiveDigits(Float number) {
        return Numbers.round(number, mc5Digits);
    }

    public static Float roundNDigits(Float number, int digits) {
        return Numbers.round(number, new MathContext(digits));
    }

    public static Float round(Float number, MathContext mc) {
        float old = number.floatValue();
        float partieEntier = (int)old;
        float digit = old - (float)((int)old);
        number = Float.valueOf(partieEntier + new BigDecimal(digit).round(mc).floatValue());
        return number;
    }
}

