/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean.definition;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.JavaBeanComparatorBuilder;
import io.ultreia.java4all.bean.JavaBeanInstanceBuilder;
import io.ultreia.java4all.bean.JavaBeanPredicate;
import io.ultreia.java4all.bean.definition.JavaBeanPropertyDefinition;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface JavaBeanDefinition {
    public Set<Class<?>> types();

    public Map<String, JavaBeanPropertyDefinition<?, ?>> properties();

    default public Stream<JavaBeanPropertyDefinition<?, ?>> readProperties() {
        return this.properties().values().stream().filter(JavaBeanPropertyDefinition::canRead);
    }

    default public Stream<JavaBeanPropertyDefinition<?, ?>> writeProperties() {
        return this.properties().values().stream().filter(JavaBeanPropertyDefinition::canWrite);
    }

    default public Stream<JavaBeanPropertyDefinition<?, ?>> readAndWriteProperties() {
        return this.properties().values().stream().filter(JavaBeanPropertyDefinition::canReadAndWrite);
    }

    default public <V> V get(String propertyName, JavaBean source) {
        JavaBeanPropertyDefinition<JavaBean, V> readDefinition = this.readProperty(propertyName);
        return readDefinition.get(source);
    }

    default public <O extends JavaBean, V> JavaBeanPropertyDefinition<O, V> property(String propertyName) {
        return Objects.requireNonNull(this.properties().get(propertyName), String.format("Can't find property %s.", propertyName));
    }

    default public <V> void set(String propertyName, JavaBean target, V propertyValue) {
        JavaBeanPropertyDefinition<JavaBean, V> writeDefinition = this.writeProperty(propertyName);
        writeDefinition.set(target, propertyValue);
    }

    default public <V> void copy(String propertyName, JavaBean source, JavaBean target) {
        boolean sameDefinition = target.javaBeanDefinition().equals(this);
        if (sameDefinition) {
            JavaBeanPropertyDefinition<JavaBean, V> readAndWriteDefinition = this.readAndWriteProperty(propertyName);
            readAndWriteDefinition.copy(source, target);
        } else {
            JavaBeanPropertyDefinition<JavaBean, V> readDefinition = this.readProperty(propertyName);
            V value = readDefinition.get(source);
            target.set(propertyName, value);
        }
    }

    default public void copy(JavaBean source, JavaBean target) {
        boolean sameDefinition = target.javaBeanDefinition().equals(this);
        if (sameDefinition) {
            this.readAndWriteProperties().forEach(propertyDefinition -> propertyDefinition.copy(source, target));
        } else {
            Map<String, JavaBeanPropertyDefinition<?, ?>> targetProperties = target.javaBeanDefinition().properties();
            for (JavaBeanPropertyDefinition readDefinition : this.readProperties().collect(Collectors.toSet())) {
                JavaBeanPropertyDefinition<?, ?> writeDefinition = targetProperties.get(readDefinition.propertyName());
                if (writeDefinition == null || !writeDefinition.canWrite()) continue;
                Object value = readDefinition.get(source);
                writeDefinition.set(target, value);
            }
        }
    }

    default public void clear(JavaBean target) {
        this.writeProperties().forEach(propertyDefinition -> propertyDefinition.clear(target));
    }

    default public <O extends JavaBean, V> JavaBeanPropertyDefinition<O, V> readProperty(String propertyName) {
        return this.property(propertyName).checkCanRead();
    }

    default public <O extends JavaBean, V> JavaBeanPropertyDefinition<O, V> writeProperty(String propertyName) {
        return this.property(propertyName).checkCanWrite();
    }

    default public <O extends JavaBean, V> JavaBeanPropertyDefinition<O, V> readAndWriteProperty(String propertyName) {
        return this.property(propertyName).checkCanRead().checkCanWrite();
    }

    default public JavaBeanPredicate<?, ?> predicateBuilder() {
        throw new UnsupportedOperationException();
    }

    default public JavaBeanComparatorBuilder<?> comparatorBuilder() {
        throw new UnsupportedOperationException();
    }

    default public JavaBeanInstanceBuilder<?> instanceBuilder() {
        throw new UnsupportedOperationException();
    }

    public <O extends JavaBean> O newInstance();
}

