/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean;

import io.ultreia.java4all.bean.JavaBean;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface JavaBeanComparatorBuilder<O extends JavaBean> {
    public void addComparator(Comparator<O> var1);

    public Optional<Comparator<O>> build();

    public static class Query<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanComparatorBuilder<O>> {
        private final P parent;
        private final Function<O, V> getter;

        protected Query(P parent, Function<O, V> getter) {
            this.parent = parent;
            this.getter = getter;
        }

        public P parent() {
            return this.parent;
        }

        public V getter(O element) {
            return (V)(element == null ? null : (Comparable)this.getter.apply(element));
        }

        public P sort() {
            return this.addComparator(Comparator.comparing(this::getter));
        }

        public P reservedSort() {
            return this.addComparator(Comparator.comparing(this::getter).reversed());
        }

        public P addComparator(Comparator<O> comparator) {
            P parent = this.parent();
            parent.addComparator(Objects.requireNonNull(comparator));
            return parent;
        }
    }
}

