/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class ConfigVisitor {
    final Config config = new Config();

    ConfigVisitor() {
    }

    void visit(Node node) {
        for (String string : node.base.getAttributeNames()) {
            new Leaf("@" + string, node.base.getAttribute(string).replaceAll("'", "\\\\'")).accept(this);
        }
        for (String string : node.base.getChildren()) {
            if (string.getChildCount() == 0 && string.getAttributeNames().length == 0) {
                new Leaf(string.getName(), string.getValue()).accept(this);
                continue;
            }
            if (string.getChildCount() > 1 && string.getChild(0).getName().equals(string.getChild(1).getName()) || string.getChildCount() == 1 && string.getName().equals(string.getChild(0).getName() + "s")) {
                new ListNode((Xpp3Dom)string).accept(this);
                continue;
            }
            new Node((Xpp3Dom)string).accept(this);
        }
    }

    static class ListNode
    extends Node {
        ListNode(Xpp3Dom base) {
            super(base);
        }

        @Override
        void accept(ConfigVisitor visitor) {
            if (this.base.getChild(0).getChildCount() == 0) {
                Config list = new Config();
                for (Xpp3Dom child : this.base.getChildren()) {
                    list.add(child);
                }
                visitor.config.put(this.base.getName(), list);
            } else {
                Config list = new Config();
                for (Xpp3Dom child : this.base.getChildren()) {
                    ConfigVisitor nextVisitor = new ConfigVisitor();
                    nextVisitor.visit(new Node(child));
                    list.add(nextVisitor.config.map);
                }
                visitor.config.put(this.base.getName(), list);
            }
        }
    }

    static class ListItem {
        final String xml;
        final String value;

        ListItem(String value) {
            this.value = value;
            this.xml = null;
        }

        ListItem(Xpp3Dom xml) {
            this.value = null;
            this.xml = xml.toString().replaceFirst("<?.*?>\\s*", "");
        }

        boolean isXml() {
            return this.xml != null;
        }

        public String toString() {
            return this.xml == null ? this.value : this.xml;
        }
    }

    static class Node {
        Xpp3Dom base;

        Node(Xpp3Dom base) {
            this.base = base;
        }

        void accept(ConfigVisitor visitor) {
            ConfigVisitor nextVisitor = new ConfigVisitor();
            nextVisitor.visit(this);
            visitor.config.put(this.base.getName(), nextVisitor.config);
        }
    }

    static class Leaf {
        private String value;
        private String name;

        Leaf(String name, String value) {
            this.name = name;
            this.value = value;
        }

        void accept(ConfigVisitor visitor) {
            visitor.config.get(this.name).add(this.value);
        }
    }

    static class Config {
        Type type;
        String value;
        List<String> stringList;
        List<ListItem> list;
        List<Map<String, Config>> mapList;
        Map<String, Config> map;

        Config() {
        }

        void add(String value) {
            if (this.stringList != null) {
                this.stringList.add(value);
            } else if (this.value == null) {
                this.type = Type.SINGLE;
                this.value = value;
            } else {
                this.type = Type.MULTI;
                this.stringList = new LinkedList<String>();
                this.stringList.add(this.value);
                this.stringList.add(value);
                this.value = null;
            }
        }

        void add(Xpp3Dom item) {
            if (this.list == null) {
                this.type = Type.MIXED;
                this.list = new LinkedList<ListItem>();
            }
            if (item.getValue() == null) {
                this.list.add(new ListItem(item));
            } else {
                this.list.add(new ListItem(item.getValue()));
            }
        }

        void add(Map<String, Config> map) {
            if (this.mapList == null) {
                this.type = Type.MAPS;
                this.mapList = new LinkedList<Map<String, Config>>();
            }
            this.mapList.add(map);
        }

        void put(String name, Config config) {
            if (this.map == null) {
                this.type = Type.MAP;
                this.map = new LinkedHashMap<String, Config>();
            }
            this.map.put(name, config);
        }

        Config get(String name) {
            if (this.map == null) {
                this.type = Type.MAP;
                this.map = new LinkedHashMap<String, Config>();
            }
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            Config config = new Config();
            this.map.put(name, config);
            return config;
        }

        static enum Type {
            SINGLE,
            MULTI,
            MIXED,
            MAPS,
            MAP;

        }
    }
}

