/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ObjcClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String CLASS_PREFIX = "classPrefix";
    public static final String POD_NAME = "podName";
    public static final String AUTHOR_NAME = "authorName";
    public static final String AUTHOR_EMAIL = "authorEmail";
    public static final String LICENSE = "license";
    public static final String GIT_REPO_URL = "gitRepoURL";
    public static final String DEFAULT_LICENSE = "Proprietary";
    public static final String CORE_DATA = "coreData";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String podName = "SwaggerClient";
    protected String podVersion = "1.0.0";
    protected String classPrefix = "SWG";
    protected String authorName = "Swagger";
    protected String authorEmail = "apiteam@swagger.io";
    protected String license = "Proprietary";
    protected String gitRepoURL = "https://github.com/swagger-api/swagger-codegen";
    protected String[] specialWords = new String[]{"new", "copy"};
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String modelFilesPath = "Model/";
    protected String coreFilesPath = "Core/";
    protected String apiFilesPath = "Api/";
    protected boolean generateCoreData = false;
    protected Set<String> advancedMapingTypes = new HashSet<String>();

    public ObjcClientCodegen() {
        this.supportsInheritance = true;
        this.outputFolder = "generated-code" + File.separator + "objc";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".m");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".m");
        this.templateDir = "objc";
        this.embeddedTemplateDir = "objc";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.defaultIncludes.clear();
        this.defaultIncludes.add("bool");
        this.defaultIncludes.add("BOOL");
        this.defaultIncludes.add("int");
        this.defaultIncludes.add("NSURL");
        this.defaultIncludes.add("NSString");
        this.defaultIncludes.add("NSObject");
        this.defaultIncludes.add("NSArray");
        this.defaultIncludes.add("NSNumber");
        this.defaultIncludes.add("NSDate");
        this.defaultIncludes.add("NSDictionary");
        this.defaultIncludes.add("NSMutableArray");
        this.defaultIncludes.add("NSMutableDictionary");
        this.defaultIncludes.add("NSManagedObject");
        this.defaultIncludes.add("NSData");
        this.advancedMapingTypes.add("NSDictionary");
        this.advancedMapingTypes.add("NSArray");
        this.advancedMapingTypes.add("NSMutableArray");
        this.advancedMapingTypes.add("NSMutableDictionary");
        this.advancedMapingTypes.add("NSObject");
        this.advancedMapingTypes.add("NSNumber");
        this.advancedMapingTypes.add("NSURL");
        this.advancedMapingTypes.add("NSString");
        this.advancedMapingTypes.add("NSDate");
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("NSNumber");
        this.languageSpecificPrimitives.add("NSString");
        this.languageSpecificPrimitives.add("NSObject");
        this.languageSpecificPrimitives.add("NSDate");
        this.languageSpecificPrimitives.add("NSData");
        this.languageSpecificPrimitives.add("NSURL");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("BOOL");
        this.typeMapping.clear();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("date", "NSDate");
        this.typeMapping.put("datetime", "NSDate");
        this.typeMapping.put("boolean", "NSNumber");
        this.typeMapping.put("string", "NSString");
        this.typeMapping.put("integer", "NSNumber");
        this.typeMapping.put("int", "NSNumber");
        this.typeMapping.put("float", "NSNumber");
        this.typeMapping.put("long", "NSNumber");
        this.typeMapping.put("double", "NSNumber");
        this.typeMapping.put("array", "NSArray");
        this.typeMapping.put("map", "NSDictionary");
        this.typeMapping.put("number", "NSNumber");
        this.typeMapping.put("bigdecimal", "NSNumber");
        this.typeMapping.put("List", "NSArray");
        this.typeMapping.put("object", "NSObject");
        this.typeMapping.put("file", "NSURL");
        this.typeMapping.put("binary", "NSData");
        this.typeMapping.put("bytearray", "NSData");
        this.typeMapping.put("byte", "NSData");
        this.typeMapping.put("uuid", "NSString");
        this.typeMapping.put("password", "NSString");
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "pathParams", "queryParams", "headerParams", "responseContentType", "requestContentType", "authSettings", "formParams", "localVarFiles", "bodyParam", "auto", "else", "long", "switch", "break", "enum", "register", "typedef", "case", "extern", "return", "union", "char", "float", "short", "unsigned", "const", "for", "signed", "void", "continue", "goto", "sizeof", "volatile", "default", "if", "id", "static", "while", "do", "int", "struct", "_Packed", "double", "protocol", "interface", "implementation", "NSObject", "NSInteger", "NSNumber", "CGFloat", "property", "nonatomic", "retain", "strong", "weak", "unsafe_unretained", "readwrite", "readonly", "description"));
        this.importMapping = new HashMap();
        this.foundationClasses = new HashSet<String>(Arrays.asList("NSNumber", "NSObject", "NSString", "NSDate", "NSData", "NSURL", "NSDictionary"));
        this.instantiationTypes.put("array", "NSMutableArray");
        this.instantiationTypes.put("map", "NSMutableDictionary");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(CORE_DATA, "Should generate core data models").defaultValue("false"));
        this.cliOptions.add(new CliOption(CLASS_PREFIX, "prefix for generated classes (convention: Abbreviation of pod name e.g. `HN` for `HackerNews`).`").defaultValue("SWG"));
        this.cliOptions.add(new CliOption(POD_NAME, "cocoapods package name (convention: CameCase).").defaultValue("SwaggerClient"));
        this.cliOptions.add(new CliOption("podVersion", "cocoapods package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(AUTHOR_NAME, "Name to use in the podspec file.").defaultValue("Swagger"));
        this.cliOptions.add(new CliOption(AUTHOR_EMAIL, "Email to use in the podspec file.").defaultValue("apiteam@swagger.io"));
        this.cliOptions.add(new CliOption(GIT_REPO_URL, "URL for the git repo where this podspec should point to.").defaultValue("https://github.com/swagger-api/swagger-codegen"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "objc";
    }

    @Override
    public String getHelp() {
        return "Generates an Objective-C client library.";
    }

    @Override
    public void processOpts() {
        Object coreData;
        super.processOpts();
        if (!this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.TRUE.toString());
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.valueOf(this.additionalProperties().get("hideGenerationTimestamp").toString()));
        }
        if (this.additionalProperties.containsKey(POD_NAME)) {
            this.setPodName((String)this.additionalProperties.get(POD_NAME));
        }
        if (this.additionalProperties.containsKey("podVersion")) {
            this.setPodVersion((String)this.additionalProperties.get("podVersion"));
        }
        if (this.additionalProperties.containsKey(CORE_DATA) && ((String)(coreData = this.additionalProperties.get(CORE_DATA))).equalsIgnoreCase("true")) {
            this.generateCoreData = true;
        }
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        if (this.additionalProperties.containsKey(AUTHOR_NAME)) {
            this.setAuthorName((String)this.additionalProperties.get(AUTHOR_NAME));
        }
        if (this.additionalProperties.containsKey(AUTHOR_EMAIL)) {
            this.setAuthorEmail((String)this.additionalProperties.get(AUTHOR_EMAIL));
        }
        if (this.additionalProperties.containsKey(GIT_REPO_URL)) {
            this.setGitRepoURL((String)this.additionalProperties.get(GIT_REPO_URL));
        }
        if (this.generateCoreData) {
            this.modelTemplateFiles.put("NSManagedObject-header.mustache", "ManagedObject.h");
            this.modelTemplateFiles.put("NSManagedObject-body.mustache", "ManagedObject.m");
            this.modelTemplateFiles.put("NSManagedObjectBuilder-header.mustache", "ManagedObjectBuilder.h");
            this.modelTemplateFiles.put("NSManagedObjectBuilder-body.mustache", "ManagedObjectBuilder.m");
        }
        this.additionalProperties.put(POD_NAME, this.podName);
        this.additionalProperties.put("podVersion", this.podVersion);
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        this.additionalProperties.put(AUTHOR_NAME, this.authorName);
        this.additionalProperties.put(AUTHOR_EMAIL, this.authorEmail);
        this.additionalProperties.put(GIT_REPO_URL, this.gitRepoURL);
        this.additionalProperties.put(LICENSE, this.license);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("useCoreData", this.generateCoreData);
        this.modelPackage = this.podName;
        this.apiPackage = this.podName;
        this.supportingFiles.add(new SupportingFile("Object-header.mustache", this.coreFileFolder(), this.classPrefix + "Object.h"));
        this.supportingFiles.add(new SupportingFile("Object-body.mustache", this.coreFileFolder(), this.classPrefix + "Object.m"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-header.mustache", this.coreFileFolder(), this.classPrefix + "QueryParamCollection.h"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-body.mustache", this.coreFileFolder(), this.classPrefix + "QueryParamCollection.m"));
        this.supportingFiles.add(new SupportingFile("ApiClient-header.mustache", this.coreFileFolder(), this.classPrefix + "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("ApiClient-body.mustache", this.coreFileFolder(), this.classPrefix + "ApiClient.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-body.mustache", this.coreFileFolder(), this.classPrefix + "JSONRequestSerializer.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-header.mustache", this.coreFileFolder(), this.classPrefix + "JSONRequestSerializer.h"));
        this.supportingFiles.add(new SupportingFile("ResponseDeserializer-body.mustache", this.coreFileFolder(), this.classPrefix + "ResponseDeserializer.m"));
        this.supportingFiles.add(new SupportingFile("ResponseDeserializer-header.mustache", this.coreFileFolder(), this.classPrefix + "ResponseDeserializer.h"));
        this.supportingFiles.add(new SupportingFile("Sanitizer-body.mustache", this.coreFileFolder(), this.classPrefix + "Sanitizer.m"));
        this.supportingFiles.add(new SupportingFile("Sanitizer-header.mustache", this.coreFileFolder(), this.classPrefix + "Sanitizer.h"));
        this.supportingFiles.add(new SupportingFile("Logger-body.mustache", this.coreFileFolder(), this.classPrefix + "Logger.m"));
        this.supportingFiles.add(new SupportingFile("Logger-header.mustache", this.coreFileFolder(), this.classPrefix + "Logger.h"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601-body.mustache", this.coreFileFolder(), "JSONValueTransformer+ISO8601.m"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601-header.mustache", this.coreFileFolder(), "JSONValueTransformer+ISO8601.h"));
        this.supportingFiles.add(new SupportingFile("Configuration-protocol.mustache", this.coreFileFolder(), this.classPrefix + "Configuration.h"));
        this.supportingFiles.add(new SupportingFile("DefaultConfiguration-body.mustache", this.coreFileFolder(), this.classPrefix + "DefaultConfiguration.m"));
        this.supportingFiles.add(new SupportingFile("DefaultConfiguration-header.mustache", this.coreFileFolder(), this.classPrefix + "DefaultConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("BasicAuthTokenProvider-header.mustache", this.coreFileFolder(), this.classPrefix + "BasicAuthTokenProvider.h"));
        this.supportingFiles.add(new SupportingFile("BasicAuthTokenProvider-body.mustache", this.coreFileFolder(), this.classPrefix + "BasicAuthTokenProvider.m"));
        this.supportingFiles.add(new SupportingFile("api-protocol.mustache", this.coreFileFolder(), this.classPrefix + "Api.h"));
        this.supportingFiles.add(new SupportingFile("podspec.mustache", "", this.podName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.generateCoreData) {
            this.supportingFiles.add(new SupportingFile("xccurrentversion.mustache", (this.modelPackage() + "/" + this.modelFilesPath + "/").replace("/", File.separator) + this.classPrefix + "Model.xcdatamodeld", ".xccurrentversion"));
            this.supportingFiles.add(new SupportingFile("Model.xcdatamodel.mustache", (this.modelPackage() + "/" + this.modelFilesPath + "/").replace("/", File.separator) + this.classPrefix + "Model.xcdatamodeld" + File.separator + this.classPrefix + "Model.xcdatamodel", "contents"));
        }
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (schema instanceof MapSchema) {
            return (String)this.instantiationTypes.get("map");
        }
        if (schema instanceof ArraySchema) {
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String swaggerType = super.getSchemaType(propertySchema);
        String type = null;
        if (swaggerType == null) {
            swaggerType = "";
        }
        if (this.typeMapping.containsKey(swaggerType.toLowerCase())) {
            type = (String)this.typeMapping.get(swaggerType.toLowerCase());
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelNameWithoutReservedWordCheck(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelNameWithoutReservedWordCheck(type);
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            if (this.languageSpecificPrimitives.contains(innerTypeDeclaration)) {
                return String.format("%s<%s>", this.getSchemaType(schema), innerTypeDeclaration);
            }
            for (String sd : this.advancedMapingTypes) {
                if (!innerTypeDeclaration.startsWith(sd)) continue;
                return String.format("%s<%s>", this.getSchemaType(schema), innerTypeDeclaration);
            }
            return String.format("%s<%s>", this.getSchemaType(schema), innerTypeDeclaration);
        }
        if (schema instanceof MapSchema && ObjcClientCodegen.hasSchemaProperties(schema)) {
            Schema inner = (Schema)schema.getAdditionalProperties();
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            if (this.languageSpecificPrimitives.contains(innerTypeDeclaration)) {
                return String.format("%s<NSString*, %s*>*", this.getSchemaType(schema), innerTypeDeclaration);
            }
            for (String s : this.advancedMapingTypes) {
                if (!innerTypeDeclaration.startsWith(s)) continue;
                return String.format("%s<NSString*, %s*>*", this.getSchemaType(schema), innerTypeDeclaration);
            }
            return String.format("%s<%s>", this.getSchemaType(schema), innerTypeDeclaration);
        }
        String swaggerType = this.getSchemaType(schema);
        if (this.languageSpecificPrimitives.contains(swaggerType) && this.foundationClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return swaggerType + "*";
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType.toLowerCase().startsWith("nsdata");
    }

    @Override
    public String toModelName(String type) {
        if (this.reservedWords.contains(type)) {
            LOGGER.warn(type + " (reserved word) cannot be used as model name. Renamed to " + "model_" + type + " before further processing");
            type = "model_" + type;
        }
        return this.toModelNameWithoutReservedWordCheck(type);
    }

    public String toModelNameWithoutReservedWordCheck(String type) {
        type = type.replaceAll("[^0-9a-zA-Z_]", "_");
        if (this.typeMapping.keySet().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return ObjcClientCodegen.camelize(type);
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            type = type + "_" + this.modelNameSuffix;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            type = this.modelNamePrefix + "_" + type;
        }
        return this.classPrefix + ObjcClientCodegen.camelize(type);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        super.setNonArrayMapProperty(property, type);
        property.setter = "NSDictionary".equals(type) ? "initWithDictionary" : "initWithValues";
    }

    @Override
    public String toModelImport(String name) {
        return name;
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace("/", File.separator);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace("/", File.separator);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/" + this.apiPackage() + "/" + this.apiFilesPath).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/" + this.modelPackage() + "/" + this.modelFilesPath).replace("/", File.separator);
    }

    public String coreFileFolder() {
        return (this.apiPackage() + "/" + this.coreFilesPath).replace("/", File.separator);
    }

    @Override
    public String toApiName(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]$")) {
            return name;
        }
        for (String specialWord : this.specialWords) {
            if (!name.matches("(?i:^" + specialWord + ".*)")) continue;
            name = this.escapeSpecialWord(name);
        }
        if (this.isReservedWord(name = ObjcClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    public String escapeSpecialWord(String name) {
        return "var_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + ObjcClientCodegen.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return ObjcClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    public void setClassPrefix(String classPrefix) {
        this.classPrefix = classPrefix;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public void setPodVersion(String podVersion) {
        this.podVersion = podVersion;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setGitRepoURL(String gitRepoURL) {
        this.gitRepoURL = gitRepoURL;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.allParams.isEmpty()) continue;
                String firstParamName = operation.allParams.get((int)0).paramName;
                operation.vendorExtensions.put("firstParamAltName", ObjcClientCodegen.camelize(firstParamName));
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        property.vendorExtensions.put("x-uppercaseName", ObjcClientCodegen.camelize(property.name));
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        if (propertySchema instanceof StringSchema) {
            if (propertySchema.getDefault() != null) {
                return String.format("@\"%s\"", propertySchema.getDefault());
            }
        } else if (propertySchema instanceof BooleanSchema) {
            if (propertySchema.getDefault() != null) {
                if (propertySchema.getDefault().toString().equalsIgnoreCase("false")) {
                    return "@(NO)";
                }
                return "@(YES)";
            }
        } else if (!(propertySchema instanceof DateSchema) && !(propertySchema instanceof DateTimeSchema) && propertySchema.getDefault() != null) {
            return String.format("@%s", propertySchema.getDefault());
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("NSString*".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "@\"" + this.escapeText(example) + "\"";
        } else if ("NSNumber*".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = "@" + example;
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("NSURL*".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "[NSURL fileURLWithPath:@\"" + this.escapeText(example) + "\"]";
        } else if ("NSDate*".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "@\"" + this.escapeText(example) + "\"";
        } else if ("NSData".equalsIgnoreCase(type)) {
            example = "1234";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            type = type.replace("*", "");
            example = "[[" + type + " alloc] init]";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "NULL";
        } else if (ExtensionHelper.getBooleanValue(p, "x-is-list-container")) {
            example = "@[" + example + "]";
        } else if (ExtensionHelper.getBooleanValue(p, "x-is-map-container")) {
            example = "@{@\"key\" : " + example + "}";
        }
        p.example = example;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

