/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FinchServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "finch-server";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";
    protected String packageName = "io.swagger";

    public FinchServerCodegen() {
        this.outputFolder = "generated-code/finch";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "finch";
        this.embeddedTemplateDir = "finch";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield", "abstract", "continue", "switch", "assert", "default", "synchronized", "goto", "break", "double", "implements", "byte", "public", "throws", "enum", "instanceof", "transient", "int", "short", "char", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("date-time", "ZonedDateTime");
        this.typeMapping.put("date", "LocalDateTime");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "Array[Byte]");
        this.typeMapping.put("Date", "LocalDateTime");
        this.typeMapping.put("DateTime", "ZonedDateTime");
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "http://swagger.io");
        this.additionalProperties.put("infoEmail", "apiteam@swagger.io");
        this.additionalProperties.put("licenseInfo", "Apache 2.0");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("Server.mustache", this.sourceFolder, "Server.scala"));
        this.supportingFiles.add(new SupportingFile("DataAccessor.mustache", this.sourceFolder, "DataAccessor.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("sbt", "", "sbt"));
        this.supportingFiles.add(new SupportingFile("endpoint.mustache", this.sourceFolder, "endpoint.scala"));
        this.supportingFiles.add(new SupportingFile("errors.mustache", this.sourceFolder, "errors.scala"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Double", "Int", "Integer", "Long", "Float", "Any", "AnyVal", "AnyRef", "Object"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "scala.collection.immutable.Map");
        this.importMapping.put("HashMap", "scala.collection.immutable.HashMap");
        this.importMapping.put("Seq", "scala.collection.immutable.Seq");
        this.importMapping.put("ArrayBuffer", "scala.collection.mutable.ArrayBuffer");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Finch package name (e.g. io.swagger).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "finch";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application with Finch.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        return codegenModel;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            this.generateScalaPath(op);
            this.generateInputParameters(op);
            this.authParameters(op);
            this.concatParameters(op);
        }
        return objs;
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && FinchServerCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[String, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String swaggerType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private String toPrimitive(String prim, Boolean isRequired, Boolean canBeOptional) {
        String converter = ".map(_.to" + prim + ")";
        return canBeOptional.booleanValue() ? (isRequired.booleanValue() ? converter : ".map(_" + converter + ")") : "";
    }

    private String toPathParameter(CodegenParameter p, String paramType, Boolean canBeOptional) {
        Boolean isNotAString = !p.dataType.equals("String");
        return paramType + (canBeOptional != false && !p.required ? "Option" : "") + "(\"" + p.baseName + "\")" + (isNotAString != false ? this.toPrimitive(p.dataType, p.required, canBeOptional) : "");
    }

    private String toInputParameter(CodegenParameter p) {
        return (p.required ? "" : "Option[") + p.dataType + (p.required ? "" : "]");
    }

    private String concat(String original, String addition, String op) {
        return original + (original.isEmpty() ? "" : (addition.isEmpty() ? "" : op)) + addition;
    }

    private String csvConcat(String original, String addition) {
        return this.concat(original, addition, ", ");
    }

    private String colConcat(String original, String addition) {
        return this.concat(original, addition, " :: ");
    }

    private void authParameters(CodegenOperation op) {
        String authParams = "";
        String authInputParams = "";
        String typedAuthInputParams = "";
        if (op.authMethods != null) {
            for (CodegenSecurity codegenSecurity : op.authMethods) {
                boolean isApiKey = ExtensionHelper.getBooleanValue(codegenSecurity, "x-is-api-key");
                boolean isKeyInHeader = ExtensionHelper.getBooleanValue(codegenSecurity, "x-is-key-in-header");
                boolean isKeyInQuery = ExtensionHelper.getBooleanValue(codegenSecurity, "x-is-key-in-query");
                if (isApiKey && isKeyInHeader) {
                    authParams = this.colConcat(authParams, "header(\"" + codegenSecurity.keyParamName + "\")");
                } else if (isApiKey && isKeyInQuery) {
                    authParams = this.colConcat(authParams, "param(\"" + codegenSecurity.keyParamName + "\")");
                }
                if (!isApiKey) continue;
                typedAuthInputParams = this.csvConcat(typedAuthInputParams, "authParam" + codegenSecurity.name + ": String");
                authInputParams = this.csvConcat(authInputParams, "authParam" + codegenSecurity.name);
            }
        }
        op.vendorExtensions.put("x-codegen-authParams", authParams);
        op.vendorExtensions.put("x-codegen-authInputParams", authInputParams);
        op.vendorExtensions.put("x-codegen-typedAuthInputParams", typedAuthInputParams);
    }

    private void generateScalaPath(CodegenOperation op) {
        op.httpMethod = op.httpMethod.toLowerCase();
        String path = new String(op.path);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] items = path.split("/", -1);
        String scalaPath = "";
        Integer pathParamIndex = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].matches("^\\{(.*)\\}$")) {
                CodegenParameter cp = op.pathParams.get(pathParamIndex);
                scalaPath = this.colConcat(scalaPath, cp.dataType.toLowerCase());
                Integer n = pathParamIndex;
                Integer n2 = pathParamIndex = Integer.valueOf(pathParamIndex + 1);
                continue;
            }
            scalaPath = this.colConcat(scalaPath, "\"" + items[i] + "\"");
        }
        op.vendorExtensions.put("x-codegen-path", scalaPath);
    }

    private void concatParameters(CodegenOperation op) {
        String path = this.colConcat(this.colConcat(op.vendorExtensions.get("x-codegen-path").toString(), op.vendorExtensions.get("x-codegen-pathParams").toString()), op.vendorExtensions.get("x-codegen-authParams").toString());
        String parameters = this.csvConcat(op.vendorExtensions.get("x-codegen-inputParams").toString(), op.vendorExtensions.get("x-codegen-authInputParams").toString());
        String typedParameters = this.csvConcat(op.vendorExtensions.get("x-codegen-typedInputParams").toString(), op.vendorExtensions.get("x-codegen-typedAuthInputParams").toString());
        op.vendorExtensions.put("x-codegen-paths", path);
        op.vendorExtensions.put("x-codegen-params", parameters);
        op.vendorExtensions.put("x-codegen-typedParams", typedParameters);
    }

    private void generateInputParameters(CodegenOperation op) {
        String inputParams = "";
        String typedInputParams = "";
        String pathParams = "";
        for (CodegenParameter parameter : op.allParams) {
            if (ExtensionHelper.getBooleanValue(parameter, "x-is-body-param")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", "jsonBody[" + parameter.dataType + "]");
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", parameter.dataType);
            } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-container") || ExtensionHelper.getBooleanValue(parameter, "x-is-list-container")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(parameter, "params", false));
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", parameter.dataType.replaceAll("^[^\\[]+", "Seq"));
            } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-query-param")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(parameter, "param", true));
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(parameter));
            } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-header-param")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", this.toPathParameter(parameter, "header", true));
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(parameter));
            } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-file")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", "fileUpload(\"" + parameter.paramName + "\")");
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", "FileUpload");
            } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type") && !ExtensionHelper.getBooleanValue(parameter, "x-is-path-param")) {
                parameter.vendorExtensions.put("x-codegen-normalized-path-type", parameter.dataType.toLowerCase());
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", this.toInputParameter(parameter));
            } else {
                parameter.vendorExtensions.put("x-codegen-normalized-input-type", parameter.dataType);
            }
            if (parameter.vendorExtensions.get("x-codegen-normalized-path-type") != null) {
                pathParams = this.colConcat(pathParams, parameter.vendorExtensions.get("x-codegen-normalized-path-type").toString());
            }
            inputParams = this.csvConcat(inputParams, parameter.paramName);
            typedInputParams = this.csvConcat(typedInputParams, parameter.paramName + ": " + parameter.vendorExtensions.get("x-codegen-normalized-input-type"));
        }
        op.vendorExtensions.put("x-codegen-pathParams", pathParams);
        op.vendorExtensions.put("x-codegen-inputParams", inputParams);
        op.vendorExtensions.put("x-codegen-typedInputParams", typedInputParams);
    }
}

