/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.builders.ApiDescriptionBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationModelContextsBuilder;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;

public class RequestMappingContext {
    private final OperationModelContextsBuilder operationModelContextsBuilder;
    private final DocumentationContext documentationContext;
    private final RequestHandler handler;
    private final String requestMappingPattern;
    private final ApiDescriptionBuilder apiDescriptionBuilder;
    private final Map<String, Set<Model>> modelMap = new HashMap<String, Set<Model>>();

    public RequestMappingContext(String requestMappingId, DocumentationContext context, RequestHandler handler) {
        this.documentationContext = context;
        this.handler = handler;
        this.requestMappingPattern = "";
        this.operationModelContextsBuilder = new OperationModelContextsBuilder(context.getGroupName(), context.getDocumentationType(), requestMappingId, context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
        this.apiDescriptionBuilder = new ApiDescriptionBuilder(this.documentationContext.operationOrdering());
    }

    private RequestMappingContext(DocumentationContext context, RequestHandler handler, OperationModelContextsBuilder operationModelContextsBuilder, String requestMappingPattern) {
        this.documentationContext = context;
        this.handler = handler;
        this.operationModelContextsBuilder = operationModelContextsBuilder;
        this.requestMappingPattern = requestMappingPattern;
        this.apiDescriptionBuilder = new ApiDescriptionBuilder(this.documentationContext.operationOrdering());
    }

    private RequestMappingContext(DocumentationContext context, RequestHandler handler, OperationModelContextsBuilder operationModelContextsBuilder, String requestMappingPattern, Map<String, Set<Model>> knownModels) {
        this.documentationContext = context;
        this.handler = handler;
        this.operationModelContextsBuilder = operationModelContextsBuilder;
        this.requestMappingPattern = requestMappingPattern;
        this.apiDescriptionBuilder = new ApiDescriptionBuilder(this.documentationContext.operationOrdering());
        this.modelMap.putAll(knownModels);
    }

    public DocumentationContext getDocumentationContext() {
        return this.documentationContext;
    }

    public String getRequestMappingPattern() {
        return this.requestMappingPattern;
    }

    public Map<String, Set<Model>> getModelMap() {
        return Collections.unmodifiableMap(this.modelMap);
    }

    public OperationModelContextsBuilder operationModelsBuilder() {
        return this.operationModelContextsBuilder;
    }

    public ApiDescriptionBuilder apiDescriptionBuilder() {
        return this.apiDescriptionBuilder;
    }

    public ResolvedType alternateFor(ResolvedType resolvedType) {
        return this.documentationContext.getAlternateTypeProvider().alternateFor(resolvedType);
    }

    public Comparator<Operation> operationOrdering() {
        return this.documentationContext.operationOrdering();
    }

    public RequestMappingContext copyPatternUsing(String requestMappingPattern) {
        return new RequestMappingContext(this.documentationContext, this.handler, this.operationModelContextsBuilder, requestMappingPattern);
    }

    public RequestMappingContext withKnownModels(Map<String, Set<Model>> knownModels) {
        return new RequestMappingContext(this.documentationContext, this.handler, this.operationModelContextsBuilder, this.requestMappingPattern, knownModels);
    }

    public Set<Class> getIgnorableParameterTypes() {
        return this.documentationContext.getIgnorableParameterTypes();
    }

    public GenericTypeNamingStrategy getGenericsNamingStrategy() {
        return this.documentationContext.getGenericsNamingStrategy();
    }

    public Set<ResolvedType> getAdditionalModels() {
        return this.documentationContext.getAdditionalModels().stream().collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.handler.getPatternsCondition();
    }

    public String getName() {
        return this.handler.getName();
    }

    public Set<RequestMethod> getMethodsCondition() {
        return this.handler.supportedMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.handler.produces();
    }

    public Set<? extends MediaType> consumes() {
        return this.handler.consumes();
    }

    public Set<NameValueExpression<String>> headers() {
        return this.handler.headers();
    }

    public Set<NameValueExpression<String>> params() {
        return this.handler.params();
    }

    public String getGroupName() {
        return this.handler.groupName();
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.handler.getParameters();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.handler.findAnnotation(annotation);
    }

    <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.handler.findControllerAnnotation(annotation);
    }

    public <T extends Annotation> List<T> findAnnotations(Class<T> annotation) {
        ArrayList annotations = new ArrayList();
        Optional<Annotation> methodAnnotation = this.findAnnotation(annotation);
        Optional<Annotation> controllerAnnotation = this.findControllerAnnotation(annotation);
        methodAnnotation.ifPresent(annotations::add);
        controllerAnnotation.ifPresent(annotations::add);
        return annotations;
    }

    public ResolvedType getReturnType() {
        return this.handler.getReturnType();
    }

    public RequestHandlerKey key() {
        return this.handler.key();
    }
}

