/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.common;

import java.util.Objects;
import java.util.Optional;

public class Compatibility<T, U> {
    private final T legacy;
    private final U modern;

    public Compatibility(T legacy, U modern) {
        this.legacy = legacy;
        this.modern = modern;
    }

    public Optional<T> getLegacy() {
        return Optional.ofNullable(this.legacy);
    }

    public Optional<U> getModern() {
        return Optional.ofNullable(this.modern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Compatibility that = (Compatibility)o;
        return Objects.equals(this.legacy, that.legacy) && Objects.equals(this.modern, that.modern);
    }

    public int hashCode() {
        return Objects.hash(this.legacy, this.modern);
    }
}

