/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.config.ConfigLogging;
import io.smallrye.jwt.config.ConfigMessages;
import io.smallrye.jwt.util.ResourceUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_SCHEME = "Bearer";
    private static final String NONE = "NONE";
    private static final String DEFAULT_GROUPS_SEPARATOR = " ";
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private String mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.algorithm")
    private Optional<SignatureAlgorithm> mpJwtPublicKeyAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private String mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.decrypt.key.location", defaultValue="NONE")
    private String mpJwtDecryptKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key.location", defaultValue="NONE")
    private String verifyKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key.location", defaultValue="NONE")
    private String decryptionKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.algorithm", defaultValue="RSA_OAEP")
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.token.header")
    private Optional<String> mpJwtTokenHeader;
    @Inject
    @ConfigProperty(name="mp.jwt.token.cookie")
    private Optional<String> mpJwtTokenCookie;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.audiences")
    Optional<Set<String>> mpJwtVerifyAudiences;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header")
    @Deprecated
    private Optional<String> tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    @Deprecated
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.always-check-authorization", defaultValue="false")
    private boolean alwaysCheckAuthorization;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    private Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.decryption.kid")
    private Optional<String> tokenDecryptionKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.schemes", defaultValue="Bearer")
    private String tokenSchemes;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="true")
    private Optional<Boolean> requireNamedPrincipal = Optional.of(Boolean.TRUE);
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    private Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    private Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    private Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.groups-separator", defaultValue=" ")
    private String groupsSeparator;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="60")
    private int expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.time-to-live")
    Optional<Long> maxTimeToLiveSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    private int jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.forced-refresh-interval", defaultValue="30")
    private int forcedJwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.algorithm")
    private Optional<SignatureAlgorithm> signatureAlgorithm;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.certificateThumbprint", defaultValue="false")
    private boolean verifyCertificateThumbprint;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key-format", defaultValue="ANY")
    private KeyFormat keyFormat;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.relax-key-validation", defaultValue="true")
    private boolean relaxVerificationKeyValidation = true;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.aud")
    @Deprecated
    Optional<Set<String>> expectedAudience;
    @Inject
    @ConfigProperty(name="smallrye.jwt.required.claims")
    Optional<Set<String>> requiredClaims;

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, false, false, issuer);
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, false, issuer);
    }

    public static JWTAuthContextInfoProvider createWithCertificate(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, true, issuer);
    }

    public static JWTAuthContextInfoProvider createWithSecretKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, true, false, issuer);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String keyLocation, boolean secretKey, boolean verifyCertificateThumbprint, String issuer) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = publicKey;
        provider.mpJwtPublicKeyAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.mpJwtLocation = !secretKey ? keyLocation : NONE;
        provider.verifyKeyLocation = secretKey ? keyLocation : NONE;
        provider.verifyCertificateThumbprint = verifyCertificateThumbprint;
        provider.mpJwtIssuer = issuer;
        provider.mpJwtDecryptKeyLocation = NONE;
        provider.decryptionKeyLocation = NONE;
        provider.mpJwtTokenHeader = Optional.of(AUTHORIZATION_HEADER);
        provider.mpJwtTokenCookie = Optional.of(BEARER_SCHEME);
        provider.tokenHeader = provider.mpJwtTokenHeader;
        provider.tokenCookie = provider.mpJwtTokenCookie;
        provider.tokenKeyId = Optional.empty();
        provider.tokenDecryptionKeyId = Optional.empty();
        provider.tokenSchemes = BEARER_SCHEME;
        provider.requireNamedPrincipal = Optional.of(Boolean.TRUE);
        provider.defaultSubClaim = Optional.empty();
        provider.subPath = Optional.empty();
        provider.defaultGroupsClaim = Optional.empty();
        provider.groupsPath = Optional.empty();
        provider.expGracePeriodSecs = 60;
        provider.maxTimeToLiveSecs = Optional.empty();
        provider.jwksRefreshInterval = 60;
        provider.forcedJwksRefreshInterval = 30;
        provider.signatureAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.keyEncryptionAlgorithm = KeyEncryptionAlgorithm.RSA_OAEP;
        provider.keyFormat = KeyFormat.ANY;
        provider.mpJwtVerifyAudiences = Optional.empty();
        provider.expectedAudience = Optional.empty();
        provider.groupsSeparator = DEFAULT_GROUPS_SEPARATOR;
        provider.requiredClaims = Optional.empty();
        return provider;
    }

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        Optional<Object> resolvedAlgorithm;
        String theDecryptionKeyLocation;
        String resolvedVerifyKeyLocation = !NONE.equals(this.verifyKeyLocation) ? this.verifyKeyLocation : this.mpJwtLocation;
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer.trim());
        }
        if (!NONE.equals(this.mpJwtPublicKey)) {
            contextInfo.setPublicKeyContent(this.mpJwtPublicKey);
        } else if (!NONE.equals(resolvedVerifyKeyLocation)) {
            String resolvedVerifyKeyLocationTrimmed = resolvedVerifyKeyLocation.trim();
            if (resolvedVerifyKeyLocationTrimmed.startsWith("http")) {
                contextInfo.setPublicKeyLocation(resolvedVerifyKeyLocationTrimmed);
            } else {
                try {
                    contextInfo.setPublicKeyContent(ResourceUtils.readResource((String)resolvedVerifyKeyLocationTrimmed));
                    if (contextInfo.getPublicKeyContent() == null) {
                        throw ConfigMessages.msg.invalidPublicKeyLocation();
                    }
                }
                catch (IOException ex) {
                    throw ConfigMessages.msg.readingPublicKeyLocationFailed(ex);
                }
            }
        }
        if (!NONE.equals(this.mpJwtDecryptKeyLocation)) {
            theDecryptionKeyLocation = this.mpJwtDecryptKeyLocation;
        } else if (!NONE.equals(this.decryptionKeyLocation)) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.decrypt.key.location", "mp.jwt.decrypt.key.location");
            theDecryptionKeyLocation = this.decryptionKeyLocation;
        } else {
            theDecryptionKeyLocation = NONE;
        }
        if (!NONE.equals(theDecryptionKeyLocation)) {
            String decryptionKeyLocationTrimmed = theDecryptionKeyLocation.trim();
            if (decryptionKeyLocationTrimmed.startsWith("http")) {
                contextInfo.setDecryptionKeyLocation(decryptionKeyLocationTrimmed);
            } else {
                try {
                    contextInfo.setDecryptionKeyContent(ResourceUtils.readResource((String)decryptionKeyLocationTrimmed));
                    if (contextInfo.getDecryptionKeyContent() == null) {
                        throw ConfigMessages.msg.invalidDecryptKeyLocation();
                    }
                }
                catch (IOException ex) {
                    throw ConfigMessages.msg.readingDecryptKeyLocationFailed(ex);
                }
            }
        }
        if (this.mpJwtTokenHeader.isPresent()) {
            contextInfo.setTokenHeader(this.mpJwtTokenHeader.get());
        } else if (this.tokenHeader.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.header", "mp.jwt.token.header");
            contextInfo.setTokenHeader(this.tokenHeader.get());
        } else {
            contextInfo.setTokenHeader(AUTHORIZATION_HEADER);
        }
        if (this.mpJwtTokenCookie.isPresent()) {
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.mpJwtTokenCookie);
        } else if (this.tokenCookie.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.cookie", "mp.jwt.token.cookie");
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.tokenCookie);
        } else {
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, Optional.of(BEARER_SCHEME));
        }
        contextInfo.setAlwaysCheckAuthorization(this.alwaysCheckAuthorization);
        contextInfo.setTokenKeyId(this.tokenKeyId.orElse(null));
        contextInfo.setTokenDecryptionKeyId(this.tokenDecryptionKeyId.orElse(null));
        contextInfo.setRequireNamedPrincipal((Boolean)this.requireNamedPrincipal.orElse(null));
        SmallryeJwtUtils.setTokenSchemes(contextInfo, this.tokenSchemes);
        contextInfo.setDefaultSubjectClaim(this.defaultSubClaim.orElse(null));
        SmallryeJwtUtils.setContextSubPath(contextInfo, this.subPath);
        contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.orElse(null));
        SmallryeJwtUtils.setContextGroupsPath(contextInfo, this.groupsPath);
        contextInfo.setExpGracePeriodSecs(this.expGracePeriodSecs);
        contextInfo.setMaxTimeToLiveSecs(this.maxTimeToLiveSecs.orElse(null));
        contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval);
        contextInfo.setForcedJwksRefreshInterval(this.forcedJwksRefreshInterval);
        if (this.mpJwtPublicKeyAlgorithm.isPresent()) {
            resolvedAlgorithm = this.mpJwtPublicKeyAlgorithm;
        } else if (this.signatureAlgorithm.isPresent()) {
            if (this.signatureAlgorithm.get().getAlgorithm().startsWith("HS")) {
                if (resolvedVerifyKeyLocation == this.mpJwtLocation) {
                    throw ConfigMessages.msg.hmacNotSupported();
                }
            } else {
                ConfigLogging.log.replacedConfig("smallrye.jwt.verify.algorithm", "mp.jwt.verify.publickey.algorithm");
            }
            resolvedAlgorithm = this.signatureAlgorithm;
        } else {
            resolvedAlgorithm = Optional.empty();
        }
        if (resolvedAlgorithm.isPresent()) {
            contextInfo.setSignatureAlgorithm((SignatureAlgorithm)resolvedAlgorithm.get());
        } else {
            contextInfo.setSignatureAlgorithm(SignatureAlgorithm.RS256);
        }
        contextInfo.setKeyEncryptionAlgorithm(this.keyEncryptionAlgorithm);
        contextInfo.setKeyFormat(this.keyFormat);
        if (this.mpJwtVerifyAudiences.isPresent()) {
            contextInfo.setExpectedAudience(this.mpJwtVerifyAudiences.get());
        } else if (this.expectedAudience.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.verify.aud", "mp.jwt.verify.audiences");
            contextInfo.setExpectedAudience(this.expectedAudience.get());
        } else {
            contextInfo.setExpectedAudience(null);
        }
        contextInfo.setGroupsSeparator(this.groupsSeparator);
        contextInfo.setRequiredClaims(this.requiredClaims.orElse(null));
        contextInfo.setRelaxVerificationKeyValidation(this.relaxVerificationKeyValidation);
        contextInfo.setVerifyCertificateThumbprint(this.verifyCertificateThumbprint);
        return Optional.of(contextInfo);
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

