package io.smallrye.jwt.config;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ConfigLogging_$logger extends DelegatingBasicLogger implements ConfigLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigLogging_$logger.class.getName();
    public ConfigLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void configValues(final String jwtPublicKey, final String jwtIssuer, final String jwtLocation) {
        super.log.logf(FQCN, DEBUG, null, configValues$str(), jwtPublicKey, jwtIssuer, jwtLocation);
    }
    protected String configValues$str() {
        return "SRJWT03000: init, mpJwtPublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s";
    }
    @Override
    public final void publicKeyAndLocationAreUnavailable() {
        super.log.logf(FQCN, DEBUG, null, publicKeyAndLocationAreUnavailable$str());
    }
    protected String publicKeyAndLocationAreUnavailable$str() {
        return "SRJWT03001: Neither mpJwtPublicKey nor mpJwtLocation properties are configured, JWTAuthContextInfo will not be available";
    }
    @Override
    public final void publicKeyParsedAsJwk() {
        super.log.logf(FQCN, DEBUG, null, publicKeyParsedAsJwk$str());
    }
    protected String publicKeyParsedAsJwk$str() {
        return "SRJWT03002: mpJwtPublicKey parsed as JWK(S)";
    }
    @Override
    public final void parsingPublicKeyAsJwkFailed(final String exceptionMessage) {
        super.log.logf(FQCN, DEBUG, null, parsingPublicKeyAsJwkFailed$str(), exceptionMessage);
    }
    protected String parsingPublicKeyAsJwkFailed$str() {
        return "SRJWT03003: mpJwtPublicKey failed as JWK(S), %s";
    }
    @Override
    public final void publicKeyParsedAsPem() {
        super.log.logf(FQCN, DEBUG, null, publicKeyParsedAsPem$str());
    }
    protected String publicKeyParsedAsPem$str() {
        return "SRJWT03004: mpJwtPublicKey parsed as PEM";
    }
}
