/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.registry;

import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.health.api.HealthRegistry;
import io.smallrye.mutiny.Uni;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class AbstractHealthRegistry
implements HealthRegistry {
    Map<String, Uni<HealthCheckResponse>> checks = new HashMap<String, Uni<HealthCheckResponse>>();
    private boolean checksChanged = false;
    @Inject
    AsyncHealthCheckFactory asyncHealthCheckFactory;

    public HealthRegistry register(String id, HealthCheck healthCheck) {
        return this.register(id, this.asyncHealthCheckFactory.callSync(healthCheck));
    }

    public HealthRegistry register(String id, AsyncHealthCheck asyncHealthCheck) {
        return this.register(id, this.asyncHealthCheckFactory.callAsync(asyncHealthCheck));
    }

    private HealthRegistry register(String id, Uni<HealthCheckResponse> healthCheckResponseUni) {
        try {
            this.checks.put(id, healthCheckResponseUni);
            this.checksChanged = true;
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public HealthRegistry remove(String id) {
        try {
            if (this.checks.remove(id) == null) {
                throw new IllegalStateException(String.format("ID '%s' not found", id));
            }
            this.checksChanged = true;
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Collection<Uni<HealthCheckResponse>> getChecks() {
        return Collections.unmodifiableCollection(this.checks.values());
    }

    public boolean checksChanged() {
        return this.checksChanged;
    }

    public void setAsyncHealthCheckFactory(AsyncHealthCheckFactory asyncHealthCheckFactory) {
        this.asyncHealthCheckFactory = asyncHealthCheckFactory;
    }
}

