package io.vertx.mutiny.ext.web.common.template;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.Map;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A template template uses a specific template and the data in a routing context to render a resource into a buffer.
 * <p>
 * Concrete implementations exist for several well-known template engines.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.common.template.TemplateEngine original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.common.template.TemplateEngine.class)
public class TemplateEngine {

  public static final io.smallrye.mutiny.vertx.TypeArg<TemplateEngine> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TemplateEngine((io.vertx.ext.web.common.template.TemplateEngine) obj),
    TemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.common.template.TemplateEngine delegate;
  
  public TemplateEngine(io.vertx.ext.web.common.template.TemplateEngine delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  TemplateEngine() {    this.delegate = null;
  }

  public io.vertx.ext.web.common.template.TemplateEngine getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateEngine that = (TemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  private void __render(JsonObject context, String templateFileName, Handler<AsyncResult<io.vertx.mutiny.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.buffer.Buffer> render(JsonObject context, String templateFileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __render(context, templateFileName, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.common.template.TemplateEngine#render(JsonObject,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return the Buffer instance produced by the operation
   */
  public io.vertx.mutiny.core.buffer.Buffer renderAndAwait(JsonObject context, String templateFileName) { 
    return (io.vertx.mutiny.core.buffer.Buffer) render(context, templateFileName).await().indefinitely();
  }

  /**
   * @return True if template files are cached; otherwise, false.
   */
  public boolean isCachingEnabled() { 
    boolean ret = delegate.isCachingEnabled();
    return ret;
  }

  /**
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  private void __render(Map<String, Object> context, String templateFileName, Handler<AsyncResult<io.vertx.mutiny.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.buffer.Buffer.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.core.buffer.Buffer> render(Map<String, Object> context, String templateFileName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __render(context, templateFileName, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.web.common.template.TemplateEngine#render(Map<String,Object>,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return the Buffer instance produced by the operation
   */
  public io.vertx.mutiny.core.buffer.Buffer renderAndAwait(Map<String, Object> context, String templateFileName) { 
    return (io.vertx.mutiny.core.buffer.Buffer) render(context, templateFileName).await().indefinitely();
  }

  public static  TemplateEngine newInstance(io.vertx.ext.web.common.template.TemplateEngine arg) {
    return arg != null ? new TemplateEngine(arg) : null;
  }

}
