package io.vertx.mutiny.core.datagram;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A datagram socket can be used to send {@link io.vertx.mutiny.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.mutiny.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.datagram.DatagramPacket>, io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<DatagramSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  public DatagramSocket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DatagramSocket() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.datagram.DatagramPacket> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.datagram.DatagramPacket>(o1 -> io.vertx.mutiny.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.datagram.DatagramPacket> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.datagram.DatagramPacket> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Write the given {@link io.vertx.mutiny.core.buffer.Buffer} to the {@link io.vertx.mutiny.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(packet.getDelegate(), port, host, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(io.vertx.mutiny.core.buffer.Buffer,int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host) { 
    return (Void) send(packet, port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(io.vertx.mutiny.core.buffer.Buffer,int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(io.vertx.mutiny.core.buffer.Buffer,int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(io.vertx.mutiny.core.buffer.Buffer,int,String)} but you don't need to compose it with other operations.
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndForget(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host) { 
    send(packet, port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> sender(int port, String host) { 
    io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.WriteStream.newInstance((io.vertx.core.streams.WriteStream)delegate.sender(port, host), TYPE_ARG_1);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(String str, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(str, port, host, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(String str, int port, String host) { 
    return (Void) send(str, port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,int,String)} but you don't need to compose it with other operations.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndForget(String str, int port, String host) { 
    send(str, port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(String str, String enc, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(str, enc, port, host, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,String,int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(String str, String enc, int port, String host) { 
    return (Void) send(str, enc, port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,String,int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,String,int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#send(String,String,int,String)} but you don't need to compose it with other operations.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndForget(String str, String enc, int port, String host) { 
    send(str, enc, port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the {@link io.vertx.mutiny.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the socket address
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address of the multicast group to join
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> listenMulticastGroup(String multicastAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address of the multicast group to join
   * @return the Void instance produced by the operation.
   */
  public Void listenMulticastGroupAndAwait(String multicastAddress) { 
    return (Void) listenMulticastGroup(multicastAddress).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address of the multicast group to join
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket listenMulticastGroupAndForget(String multicastAddress) { 
    listenMulticastGroup(multicastAddress).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> listenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the Void instance produced by the operation.
   */
  public Void listenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) { 
    return (Void) listenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#listenMulticastGroup(String,String,String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket listenMulticastGroupAndForget(String multicastAddress, String networkInterface, String source) { 
    listenMulticastGroup(multicastAddress, networkInterface, source).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address of the multicast group to leave
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unlistenMulticastGroup(String multicastAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unlistenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address of the multicast group to leave
   * @return the Void instance produced by the operation.
   */
  public Void unlistenMulticastGroupAndAwait(String multicastAddress) { 
    return (Void) unlistenMulticastGroup(multicastAddress).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address of the multicast group to leave
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket unlistenMulticastGroupAndForget(String multicastAddress) { 
    unlistenMulticastGroup(multicastAddress).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the Void instance produced by the operation.
   */
  public Void unlistenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) { 
    return (Void) unlistenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#unlistenMulticastGroup(String,String,String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket unlistenMulticastGroupAndForget(String multicastAddress, String networkInterface, String source) { 
    unlistenMulticastGroup(multicastAddress, networkInterface, source).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> blockMulticastGroup(String multicastAddress, String sourceToBlock) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blockMulticastGroup(multicastAddress, sourceToBlock, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the Void instance produced by the operation.
   */
  public Void blockMulticastGroupAndAwait(String multicastAddress, String sourceToBlock) { 
    return (Void) blockMulticastGroup(multicastAddress, sourceToBlock).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket blockMulticastGroupAndForget(String multicastAddress, String sourceToBlock) { 
    blockMulticastGroup(multicastAddress, sourceToBlock).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the Void instance produced by the operation.
   */
  public Void blockMulticastGroupAndAwait(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return (Void) blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#blockMulticastGroup(String,String,String)} but you don't need to compose it with other operations.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket blockMulticastGroupAndForget(String multicastAddress, String networkInterface, String sourceToBlock) { 
    blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.datagram.DatagramSocket> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.listen(port, host, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listen(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the DatagramSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) listen(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listen(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.datagram.DatagramSocket#listen(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.datagram.DatagramSocket#listen(int,String)} but you don't need to compose it with other operations.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return the instance of DatagramSocket to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket listenAndForget(int port, String host) { 
    listen(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return the instance of DatagramSocket to chain method calls.
   * @deprecated no replacement for back-pressure, instead ignore the packet or buffer it somewhere   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return the instance of DatagramSocket to chain method calls.
   * @deprecated no replacement for back-pressure, instead ignore the packet or buffer it somewhere   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param amount 
   * @return the instance of DatagramSocket to chain method calls.
   * @deprecated no replacement for back-pressure, instead ignore the packet or buffer it somewhere   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return the instance of DatagramSocket to chain method calls.
   * @deprecated removed in Vert.x 5   */
  @Deprecated
  @Fluent
  private io.vertx.mutiny.core.datagram.DatagramSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   * @deprecated removed in Vert.x 5   */
  @Deprecated
  public io.vertx.mutiny.core.datagram.DatagramSocket endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  private io.vertx.mutiny.core.datagram.DatagramSocket __handler(Handler<io.vertx.mutiny.core.datagram.DatagramPacket> handler) { 
    delegate.handler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)event)));
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket handler(java.util.function.Consumer<io.vertx.mutiny.core.datagram.DatagramPacket> handler) {
    return __handler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  @Fluent
  private io.vertx.mutiny.core.datagram.DatagramSocket __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private Multi<io.vertx.mutiny.core.datagram.DatagramPacket> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.datagram.DatagramPacket> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.mutiny.core.datagram.DatagramPacket> conv = io.vertx.mutiny.core.datagram.DatagramPacket::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.datagram.DatagramPacket> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.datagram.DatagramPacket> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
