package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A Vert.x event-bus is a light-weight distributed messaging system which allows different parts of your application,
 * or different applications and services to communicate with each in a loosely coupled way.
 * <p>
 * An event-bus supports publish-subscribe messaging, point-to-point messaging and request-response messaging.
 * <p>
 * Message delivery is best-effort and messages can be lost if failure of all or part of the event bus occurs.
 * <p>
 * Please refer to the documentation for more information on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.EventBus original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.EventBus.class)
public class EventBus implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<EventBus> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new EventBus((io.vertx.core.eventbus.EventBus) obj),
    EventBus::getDelegate
  );

  private final io.vertx.core.eventbus.EventBus delegate;
  
  public EventBus(io.vertx.core.eventbus.EventBus delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  EventBus() {    this.delegate = null;
  }

  public io.vertx.core.eventbus.EventBus getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBus that = (EventBus) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private <T> io.vertx.mutiny.core.eventbus.EventBus __send(String address, Object message, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<T>>> replyHandler) { 
    delegate.send(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.eventbus.EventBus#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public <T> Uni<io.vertx.mutiny.core.eventbus.Message<T>> send(String address, Object message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(address, message, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public <T> io.vertx.mutiny.core.eventbus.Message<T> sendAndAwait(String address, Object message) { 
    return (io.vertx.mutiny.core.eventbus.Message<T>) send(address, message).await().indefinitely();
  }

  /**
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  private <T> io.vertx.mutiny.core.eventbus.EventBus __send(String address, Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<T>>> replyHandler) { 
    delegate.send(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.eventbus.EventBus#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public <T> Uni<io.vertx.mutiny.core.eventbus.Message<T>> send(String address, Object message, DeliveryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(address, message, options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object,DeliveryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated
  public <T> io.vertx.mutiny.core.eventbus.Message<T> sendAndAwait(String address, Object message, DeliveryOptions options) { 
    return (io.vertx.mutiny.core.eventbus.Message<T>) send(address, message, options).await().indefinitely();
  }

  /**
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __request(String address, Object message, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> Uni<io.vertx.mutiny.core.eventbus.Message<T>> request(String address, Object message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __request(address, message, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.EventBus#request(String,Object)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.Message<T> requestAndAwait(String address, Object message) { 
    return (io.vertx.mutiny.core.eventbus.Message<T>) request(address, message).await().indefinitely();
  }

  /**
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __request(String address, Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.eventbus.EventBus#request} but specifying <code>options</code> that can be used to configure the delivery.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> Uni<io.vertx.mutiny.core.eventbus.Message<T>> request(String address, Object message, DeliveryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __request(address, message, options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.EventBus#request(String,Object,DeliveryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.Message<T> requestAndAwait(String address, Object message, DeliveryOptions options) { 
    return (io.vertx.mutiny.core.eventbus.Message<T>) request(address, message, options).await().indefinitely();
  }

  /**
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus publish(String address, Object message) { 
    delegate.publish(address, message);
    return this;
  }

  /**
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @param options the delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus publish(String address, Object message, DeliveryOptions options) { 
    delegate.publish(address, message, options);
    return this;
  }

  /**
   * @param address the address that it will register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> consumer(String address) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance(delegate.consumer(address), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  private <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> __consumer(String address, Handler<io.vertx.mutiny.core.eventbus.Message<T>> handler) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance(delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.mutiny.core.eventbus.Message.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> consumer(String address, Consumer<io.vertx.mutiny.core.eventbus.Message<T>> handler) {
    return __consumer(address, handler != null ? handler::accept : null);
  }

  /**
   * @param address the address to register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> localConsumer(String address) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance(delegate.localConsumer(address), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  private <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> __localConsumer(String address, Handler<io.vertx.mutiny.core.eventbus.Message<T>> handler) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance(delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.mutiny.core.eventbus.Message.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> localConsumer(String address, Consumer<io.vertx.mutiny.core.eventbus.Message<T>> handler) {
    return __localConsumer(address, handler != null ? handler::accept : null);
  }

  /**
   * @param address the address to send it to
   * @return The sender
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageProducer<T> sender(String address) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.sender(address), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address to send it to
   * @param options the delivery options
   * @return The sender
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageProducer<T> sender(String address, DeliveryOptions options) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.sender(address, options), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address The address to publish it to
   * @return The publisher
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageProducer<T> publisher(String address) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.publisher(address), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param address the address to publish it to
   * @param options the delivery options
   * @return The publisher
   */
  public <T> io.vertx.mutiny.core.eventbus.MessageProducer<T> publisher(String address, DeliveryOptions options) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.publisher(address, options), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __addOutboundInterceptor(Handler<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.mutiny.core.eventbus.DeliveryContext.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.EventBus addOutboundInterceptor(Consumer<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) {
    return __addOutboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __removeOutboundInterceptor(Handler<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.mutiny.core.eventbus.DeliveryContext.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.EventBus removeOutboundInterceptor(Consumer<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) {
    return __removeOutboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __addInboundInterceptor(Handler<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.mutiny.core.eventbus.DeliveryContext.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.EventBus addInboundInterceptor(Consumer<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) {
    return __addInboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.mutiny.core.eventbus.EventBus __removeInboundInterceptor(Handler<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.mutiny.core.eventbus.DeliveryContext.newInstance(event, io.smallrye.mutiny.vertx.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.mutiny.core.eventbus.EventBus removeInboundInterceptor(Consumer<io.vertx.mutiny.core.eventbus.DeliveryContext<T>> interceptor) {
    return __removeInboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * @param codec the message codec to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus registerCodec(MessageCodec codec) { 
    io.vertx.mutiny.core.eventbus.EventBus ret = io.vertx.mutiny.core.eventbus.EventBus.newInstance(delegate.registerCodec(codec));
    return ret;
  }

  /**
   * @param name the name of the codec
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus unregisterCodec(String name) { 
    io.vertx.mutiny.core.eventbus.EventBus ret = io.vertx.mutiny.core.eventbus.EventBus.newInstance(delegate.unregisterCodec(name));
    return ret;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object)} but you don't need to compose it with other operations.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus sendAndForget(String address, Object message) { 
    delegate.send(address, message);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object,DeliveryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object,DeliveryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.EventBus#send(String,Object,DeliveryOptions)} but you don't need to compose it with other operations.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.eventbus.EventBus sendAndForget(String address, Object message, DeliveryOptions options) { 
    delegate.send(address, message, options);
    return this;
  }

  public static  EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
    return arg != null ? new EventBus(arg) : null;
  }

}
