package io.vertx.mutiny.ext.auth.authorization;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import java.util.Set;

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.authorization.Authorizations.class)
public class Authorizations {

  public static final io.smallrye.mutiny.vertx.TypeArg<Authorizations> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Authorizations((io.vertx.ext.auth.authorization.Authorizations) obj),
    Authorizations::getDelegate
  );

  private final io.vertx.ext.auth.authorization.Authorizations delegate;
  
  public Authorizations(io.vertx.ext.auth.authorization.Authorizations delegate) {
    this.delegate = delegate;
  }

  public Authorizations(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorizations)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Authorizations() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.authorization.Authorizations getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.auth.authorization.Authorization> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.auth.authorization.Authorization>(o1 -> io.vertx.mutiny.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Authorizations that = (Authorizations) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Fluent
  public io.vertx.mutiny.ext.auth.authorization.Authorizations add(String providerId, Set<io.vertx.mutiny.ext.auth.authorization.Authorization> authorizations) { 
    delegate.add(providerId, authorizations.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toSet()));
    return this;
  }

  @Fluent
  public io.vertx.mutiny.ext.auth.authorization.Authorizations add(String providerId, io.vertx.mutiny.ext.auth.authorization.Authorization authorization) { 
    delegate.add(providerId, authorization.getDelegate());
    return this;
  }

  @Fluent
  public io.vertx.mutiny.ext.auth.authorization.Authorizations clear(String providerId) { 
    delegate.clear(providerId);
    return this;
  }

  @Fluent
  public io.vertx.mutiny.ext.auth.authorization.Authorizations clear() { 
    delegate.clear();
    return this;
  }

  public Set<io.vertx.mutiny.ext.auth.authorization.Authorization> get(String providerId) { 
    Set<io.vertx.mutiny.ext.auth.authorization.Authorization> ret = delegate.get(providerId).stream().map(elt -> io.vertx.mutiny.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  public Set<String> getProviderIds() { 
    Set<String> ret = delegate.getProviderIds();
    return ret;
  }

  public static  Authorizations newInstance(io.vertx.ext.auth.authorization.Authorizations arg) {
    return arg != null ? new Authorizations(arg) : null;
  }

}
