/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.core;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.core.Promise;
import io.vertx.axle.core.Vertx;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

@Gen(value=io.vertx.core.Context.class)
public class Context {
    public static final TypeArg<Context> __TYPE_ARG = new TypeArg(obj -> new Context((io.vertx.core.Context)obj), Context::getDelegate);
    private final io.vertx.core.Context delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    Context() {
        this.delegate = null;
    }

    public io.vertx.core.Context getDelegate() {
        return this.delegate;
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    private void __runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public void runOnContext(Consumer<Void> action) {
        this.__runOnContext(action != null ? action::accept : null);
    }

    private <T> void __executeBlocking(final Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                blockingCodeHandler.handle(Promise.newInstance(event, TypeArg.unknown()));
            }
        }, ordered, resultHandler);
    }

    public <T> CompletionStage<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__executeBlocking(blockingCodeHandler, ordered, (Handler)handler));
    }

    private <T> void __executeBlocking(final Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                blockingCodeHandler.handle(Promise.newInstance(event, TypeArg.unknown()));
            }
        }, resultHandler);
    }

    public <T> CompletionStage<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__executeBlocking(blockingCodeHandler, (Handler)handler));
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public boolean isMultiThreadedWorkerContext() {
        boolean ret = this.delegate.isMultiThreadedWorkerContext();
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(String key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(String key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    private Context __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Context exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public void addCloseHook(Closeable hook) {
        this.delegate.addCloseHook(hook);
    }

    public boolean removeCloseHook(Closeable hook) {
        boolean ret = this.delegate.removeCloseHook(hook);
        return ret;
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

