/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.subscription.PausableMulti;

@Experimental(value="This API is still being designed and may change in the future")
public class DemandPauser {
    volatile PausableMulti multi;

    public void bind(PausableMulti multi) {
        this.multi = multi;
    }

    public void pause() {
        this.ensureBound();
        this.multi.pause();
    }

    public void resume() {
        this.ensureBound();
        this.multi.resume();
    }

    public boolean isPaused() {
        this.ensureBound();
        return this.multi.isPaused();
    }

    public int bufferSize() {
        this.ensureBound();
        return this.multi.bufferSize();
    }

    public boolean clearBuffer() {
        this.ensureBound();
        return this.multi.clearBuffer();
    }

    public boolean isBound() {
        return this.multi != null;
    }

    private void ensureBound() {
        if (this.multi == null) {
            throw new IllegalStateException("DemandPauser is not bound to a stream. Make sure to use .pauseDemand().using(pauser) in the pausable configuration.");
        }
    }
}

