/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import io.smallrye.mutiny.helpers.queues.EmptyQueue;
import io.smallrye.mutiny.helpers.queues.SingletonQueue;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.Queue;
import java.util.function.Supplier;
import org.jctools.queues.unpadded.MpscUnboundedUnpaddedArrayQueue;
import org.jctools.queues.unpadded.MpscUnpaddedArrayQueue;
import org.jctools.queues.unpadded.SpscChunkedUnpaddedArrayQueue;
import org.jctools.queues.unpadded.SpscUnboundedUnpaddedArrayQueue;
import org.jctools.queues.unpadded.SpscUnpaddedArrayQueue;

public class Queues {
    private Queues() {
    }

    public static <T> Queue<T> createSpscArrayQueue(int capacity) {
        return new SpscUnpaddedArrayQueue(capacity);
    }

    public static <T> Queue<T> createSpscUnboundedArrayQueue(int chunkSize) {
        return new SpscUnboundedUnpaddedArrayQueue(chunkSize);
    }

    public static <T> Queue<T> createSpscChunkedArrayQueue(int capacity) {
        return new SpscChunkedUnpaddedArrayQueue(capacity);
    }

    public static <T> Supplier<Queue<T>> getXsQueueSupplier() {
        return () -> Queues.createSpscArrayQueue(Infrastructure.getBufferSizeXs());
    }

    public static <T> Supplier<Queue<T>> get(int capacity) {
        if (capacity == Infrastructure.getBufferSizeXs()) {
            return () -> Queues.createSpscArrayQueue(Infrastructure.getBufferSizeXs());
        }
        if (capacity == Infrastructure.getBufferSizeS()) {
            return () -> Queues.createSpscArrayQueue(Infrastructure.getBufferSizeS());
        }
        if (capacity == 1) {
            return SingletonQueue::new;
        }
        if (capacity == 0) {
            return EmptyQueue::new;
        }
        return () -> Queues.createSpscChunkedArrayQueue(capacity);
    }

    public static <T> Supplier<Queue<T>> unbounded(int chunkSize) {
        if (chunkSize == Infrastructure.getBufferSizeXs()) {
            return () -> Queues.createSpscUnboundedArrayQueue(Infrastructure.getBufferSizeXs());
        }
        if (chunkSize == Integer.MAX_VALUE || chunkSize == Infrastructure.getBufferSizeS()) {
            return () -> Queues.createSpscUnboundedArrayQueue(Infrastructure.getBufferSizeS());
        }
        return () -> Queues.createSpscUnboundedArrayQueue(chunkSize);
    }

    public static <T> Queue<T> createMpscQueue() {
        return new MpscUnboundedUnpaddedArrayQueue(Infrastructure.getBufferSizeS());
    }

    public static <T> Queue<T> createSpscUnboundedQueue(int chunkSize) {
        return new SpscUnboundedUnpaddedArrayQueue(chunkSize);
    }

    public static <T> Queue<T> createMpscArrayQueue(int capacity) {
        return new MpscUnpaddedArrayQueue(capacity);
    }
}

