/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.concurrent.Flow;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class MultiFailOnItemTimeout<I>
extends MultiOperator<I, I> {
    private final Duration timeout;
    private final Supplier<? extends Throwable> supplier;
    private final ScheduledExecutorService executor;

    public MultiFailOnItemTimeout(Multi<I> upstream, Duration timeout, Supplier<? extends Throwable> supplier, ScheduledExecutorService executor) {
        super(upstream);
        this.timeout = timeout;
        this.supplier = supplier;
        this.executor = executor == null ? Infrastructure.getDefaultWorkerPool() : executor;
    }

    @Override
    public void subscribe(MultiSubscriber<? super I> subscriber) {
        this.upstream().subscribe().withSubscriber(new MultiFailOnItemTimeoutProcessor(subscriber));
    }

    public class MultiFailOnItemTimeoutProcessor
    extends MultiOperatorProcessor<I, I> {
        private volatile ScheduledFuture<?> timeoutFuture;

        public MultiFailOnItemTimeoutProcessor(MultiSubscriber<? super I> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (!this.scheduleTimeout()) {
                subscription.cancel();
                this.downstream.onSubscribe(EmptyUniSubscription.DONE);
            }
            super.onSubscribe(subscription);
        }

        @Override
        public void onItem(I item) {
            Flow.Subscription sub = this.getUpstreamSubscription();
            if (sub != Subscriptions.CANCELLED) {
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(false);
                    if (!this.scheduleTimeout()) {
                        return;
                    }
                }
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            Flow.Subscription sub = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (sub != Subscriptions.CANCELLED) {
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(false);
                }
                this.downstream.onFailure(failure);
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        @Override
        public void onCompletion() {
            Flow.Subscription sub = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (sub != Subscriptions.CANCELLED) {
                if (this.timeoutFuture != null) {
                    this.timeoutFuture.cancel(false);
                }
                this.downstream.onCompletion();
            }
        }

        @Override
        public void cancel() {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            super.cancel();
        }

        private void doTimeout() {
            Throwable throwable;
            if (this.isCancelled()) {
                return;
            }
            super.cancel();
            try {
                throwable = MultiFailOnItemTimeout.this.supplier.get();
            }
            catch (Throwable e) {
                this.downstream.onFailure(e);
                return;
            }
            if (throwable == null) {
                this.downstream.onFailure(new NullPointerException("The supplier returned `null`"));
            } else {
                this.downstream.onFailure(throwable);
            }
        }

        private boolean scheduleTimeout() {
            try {
                this.timeoutFuture = MultiFailOnItemTimeout.this.executor.schedule(this::doTimeout, MultiFailOnItemTimeout.this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException e) {
                this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
                this.downstream.onFailure(e);
                return false;
            }
        }
    }
}

