/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Supplier;

public class UniCreateFromFailureSupplier<T>
extends AbstractUni<T> {
    private final Supplier<Throwable> supplier;

    public UniCreateFromFailureSupplier(Supplier<Throwable> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        subscriber.onSubscribe(EmptyUniSubscription.DONE);
        try {
            Throwable failure = this.supplier.get();
            if (failure == null) {
                subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
            } else {
                subscriber.onFailure(failure);
            }
        }
        catch (Throwable err) {
            subscriber.onFailure(err);
        }
    }
}

