/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class MultiOnFailureInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<Throwable> callback;
    private final Predicate<? super Throwable> predicate;

    public MultiOnFailureInvoke(Multi<? extends T> upstream, Consumer<Throwable> callback, Predicate<? super Throwable> predicate) {
        super(upstream);
        this.callback = callback;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnFailureInvokeProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnFailureInvokeProcessor
    extends MultiOperatorProcessor<T, T> {
        public MultiOnFailureInvokeProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onFailure(Throwable failure) {
            Subscription up = this.upstream.getAndSet(Subscriptions.CANCELLED);
            MultiSubscriber subscriber = this.downstream;
            if (up != Subscriptions.CANCELLED) {
                try {
                    if (MultiOnFailureInvoke.this.predicate.test(failure)) {
                        MultiOnFailureInvoke.this.callback.accept(failure);
                    }
                }
                catch (Throwable e) {
                    failure = new CompositeException(failure, e);
                }
                subscriber.onFailure(failure);
            }
        }
    }
}

