/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnTerminationCall;
import io.smallrye.mutiny.operators.multi.MultiOnTerminationInvoke;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class MultiOnTerminate<T> {
    private final Multi<T> upstream;

    public MultiOnTerminate(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(BiConsumer<Throwable, Boolean> callback) {
        BiConsumer<Throwable, Boolean> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onMultiCreation(new MultiOnTerminationInvoke<T>(this.upstream, actual));
    }

    public Multi<T> invoke(Runnable action) {
        Runnable runnable = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onMultiCreation(new MultiOnTerminationInvoke<T>(this.upstream, (f, c) -> runnable.run()));
    }

    public Multi<T> call(BiFunction<Throwable, Boolean, Uni<?>> mapper) {
        BiFunction<Throwable, Boolean, Uni<?>> actual = Infrastructure.decorate(Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper")));
        return Infrastructure.onMultiCreation(new MultiOnTerminationCall<T>(this.upstream, actual));
    }

    public Multi<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.call((Throwable ignoredFailure, Boolean ignoredCancellation) -> (Uni)actual.get());
    }
}

