/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.function.Supplier;

public class UniCreateFromDeferredSupplier<T>
extends UniOperator<Void, T> {
    private final Supplier<? extends Uni<? extends T>> supplier;

    public UniCreateFromDeferredSupplier(Supplier<? extends Uni<? extends T>> supplier) {
        super(null);
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
        Uni<T> uni;
        ParameterValidation.nonNull(subscriber, "subscriber");
        try {
            uni = this.supplier.get();
        }
        catch (Throwable e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
            return;
        }
        if (uni == null) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
        } else {
            uni.subscribe().withSubscriber(subscriber);
        }
    }
}

