/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import org.reactivestreams.Subscription;

public class MultiOnSubscribeSpy<T>
extends MultiSpyBase<T> {
    private volatile Subscription lastSubscription;

    public Subscription lastSubscription() {
        return this.lastSubscription;
    }

    MultiOnSubscribeSpy(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void reset() {
        super.reset();
        this.lastSubscription = null;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.onSubscribe().invoke((? super Subscription subscription) -> {
            this.incrementInvocationCount();
            this.lastSubscription = subscription;
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnSubscribeSpy{lastSubscription=" + this.lastSubscription + "} " + super.toString();
    }
}

