/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.groups.GeneratorEmitter;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;

public class GeneratorBasedMulti<T, S>
extends AbstractMulti<T> {
    private final Supplier<S> initialStateSupplier;
    private final BiFunction<S, GeneratorEmitter<? super T>, S> generator;

    public GeneratorBasedMulti(Supplier<S> initialStateSupplier, BiFunction<S, GeneratorEmitter<? super T>, S> generator) {
        this.initialStateSupplier = initialStateSupplier;
        this.generator = generator;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        S initialState;
        MultiSubscriber<? super T> downstream = ParameterValidation.nonNull(subscriber, "subscriber");
        try {
            initialState = this.initialStateSupplier.get();
        }
        catch (Throwable err) {
            downstream.onFailure(err);
            return;
        }
        downstream.onSubscribe(new GeneratorSubscription(downstream, initialState));
    }

    class GeneratorSubscription
    implements Subscription,
    GeneratorEmitter<T> {
        private final MultiSubscriber<? super T> downstream;
        private S state;
        protected volatile boolean cancelled;
        protected final AtomicLong requested = new AtomicLong();

        GeneratorSubscription(MultiSubscriber<? super T> downstream, S state) {
            this.downstream = downstream;
            this.state = state;
        }

        public void request(long n) {
            if (n > 0L) {
                if (Subscriptions.add(this.requested, n) == 0L) {
                    if (n == Long.MAX_VALUE) {
                        this.generateAll();
                    } else {
                        this.generateSome(n);
                    }
                }
            } else {
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        private void doGenerate() {
            try {
                this.state = GeneratorBasedMulti.this.generator.apply(this.state, this);
            }
            catch (Throwable failure) {
                this.fail(failure);
            }
        }

        private void generateAll() {
            while (!this.cancelled) {
                this.doGenerate();
            }
        }

        private void generateSome(long n) {
            long emitted = 0L;
            long upperBound = n;
            while (!this.cancelled) {
                while (!this.cancelled && emitted != upperBound) {
                    this.doGenerate();
                    ++emitted;
                    if (!this.cancelled) continue;
                    return;
                }
                if (emitted != upperBound) continue;
                upperBound = this.requested.addAndGet(-emitted);
                if (upperBound == 0L) {
                    return;
                }
                emitted = 0L;
            }
            return;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void emit(T item) {
            if (!this.cancelled) {
                this.downstream.onItem(ParameterValidation.nonNullNpe(item, "item"));
            }
        }

        @Override
        public void fail(Throwable failure) {
            if (!this.cancelled) {
                this.cancelled = true;
                if (failure != null) {
                    this.downstream.onFailure(failure);
                } else {
                    this.downstream.onFailure(new NullPointerException("The failure is null"));
                }
            }
        }

        @Override
        public void complete() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.downstream.onCompletion();
            }
        }
    }
}

