/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConverter;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigSourceInterceptorContext;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    private static final long serialVersionUID = 8138651532357898263L;
    private final AtomicReference<ConfigSources> configSources;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();
    private final ConfigMappings mappings;

    SmallRyeConfig(SmallRyeConfigBuilder builder, ConfigMappings mappings) {
        this.configSources = new AtomicReference<ConfigSources>(new ConfigSources(this.buildConfigSources(builder), this.buildInterceptors(builder)));
        this.converters = this.buildConverters(builder);
        this.mappings = mappings;
    }

    @Deprecated
    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSources = new AtomicReference<ConfigSources>(new ConfigSources(configSources, this.buildInterceptors(new SmallRyeConfigBuilder())));
        this.converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
        this.mappings = new ConfigMappings();
    }

    private List<ConfigSource> buildConfigSources(SmallRyeConfigBuilder builder) {
        ArrayList<ConfigSource> sourcesToBuild = new ArrayList<ConfigSource>(builder.getSources());
        if (builder.isAddDiscoveredSources()) {
            sourcesToBuild.addAll(builder.discoverSources());
        }
        if (builder.isAddDefaultSources()) {
            sourcesToBuild.addAll(builder.getDefaultSources());
        }
        sourcesToBuild.add((ConfigSource)new DefaultValuesConfigSource(builder.getDefaultValues()));
        Function<ConfigSource, ConfigSource> sourceWrappersToBuild = builder.getSourceWrappers();
        ListIterator<ConfigSource> it = sourcesToBuild.listIterator();
        while (it.hasNext()) {
            it.set(sourceWrappersToBuild.apply((ConfigSource)it.next()));
        }
        return sourcesToBuild;
    }

    private List<SmallRyeConfigBuilder.InterceptorWithPriority> buildInterceptors(SmallRyeConfigBuilder builder) {
        ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors = new ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority>(builder.getInterceptors());
        if (builder.isAddDiscoveredInterceptors()) {
            interceptors.addAll(builder.discoverInterceptors());
        }
        if (builder.isAddDefaultInterceptors()) {
            interceptors.addAll(builder.getDefaultInterceptors());
        }
        return interceptors;
    }

    private Map<Type, Converter<?>> buildConverters(SmallRyeConfigBuilder builder) {
        HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority> convertersToBuild = new HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority>(builder.getConverters());
        if (builder.isAddDiscoveredConverters()) {
            for (Converter<?> converter : builder.discoverConverters()) {
                Type type2 = Converters.getConverterType(converter.getClass());
                if (type2 == null) {
                    throw ConfigMessages.msg.unableToAddConverter(converter);
                }
                SmallRyeConfigBuilder.addConverter(type2, converter, convertersToBuild);
            }
        }
        ConcurrentHashMap converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        convertersToBuild.forEach((type, converterWithPriority) -> converters.put((Type)type, converterWithPriority.getConverter()));
        converters.put((Type)((Object)ConfigValue.class), ConfigValueConverter.CONFIG_VALUE_CONVERTER);
        return converters;
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
    }

    public <T> T getValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getConverter(aClass));
    }

    public <T> T getValue(String name, Converter<T> converter) {
        Object converted;
        ConfigValue configValue = this.getConfigValue(name);
        if (ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals(converter)) {
            return (T)configValue;
        }
        if (converter instanceof Converters.OptionalConverter && ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals((Object)((Converters.OptionalConverter)converter).getDelegate())) {
            return (T)Optional.of(configValue);
        }
        String value = configValue.getValue();
        if (value != null) {
            converted = converter.convert(value);
        } else {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw ConfigMessages.msg.propertyNotFound(name);
            }
        }
        if (converted == null) {
            throw ConfigMessages.msg.propertyNotFound(name);
        }
        return (T)converted;
    }

    public boolean rawValueEquals(String name, String expected) {
        return Objects.equals(expected, this.getRawValue(name));
    }

    @Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
    public ConfigValue getConfigValue(String name) {
        ConfigValue configValue = this.configSources.get().getInterceptorChain().proceed(name);
        return configValue != null ? configValue : ConfigValue.builder().withName(name).build();
    }

    public String getRawValue(String name) {
        ConfigValue configValue = this.getConfigValue(name);
        return configValue != null && configValue.getValue() != null ? configValue.getValue() : null;
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getOptionalConverter(aClass));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.getConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        return this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
    }

    public ConfigMappings getConfigMappings() {
        return this.mappings;
    }

    @Experimental(value="ConfigMapping API to group configuration properties")
    public <T> T getConfigMapping(Class<T> type) {
        return this.mappings.getConfigMapping(type);
    }

    @Experimental(value="ConfigMapping API to group configuration properties")
    public <T> T getConfigMapping(Class<T> type, String prefix) {
        return this.mappings.getConfigMapping(type, prefix);
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        this.configSources.get().getInterceptorChain().iterateNames().forEachRemaining(names::add);
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources.get().getSources();
    }

    @Deprecated
    public void addConfigSource(ConfigSource configSource) {
        this.configSources.updateAndGet(configSources -> new ConfigSources((ConfigSources)configSources, configSource));
    }

    public <T> T convert(String value, Class<T> asType) {
        return (T)(value != null ? this.getConverter(asType).convert(value) : null);
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        return this.optionalConverters.computeIfAbsent(asType, clazz -> Converters.newOptionalConverter(this.getConverter((Class)clazz)));
    }

    public <T> Converter<T> getConverter(Class<T> asType) {
        Converter<?> exactConverter = this.converters.get(asType);
        if (exactConverter != null) {
            return exactConverter;
        }
        if (asType.isPrimitive()) {
            return this.getConverter(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            return Converters.newArrayConverter(this.getConverter(asType.getComponentType()), asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> {
            Converter conv = ImplicitConverters.getConverter((Class)clazz);
            if (conv == null) {
                throw ConfigMessages.msg.noRegisteredConverter(asType);
            }
            return conv;
        });
    }

    static class ConfigSourceInterceptorWithPriority
    implements Comparable<ConfigSourceInterceptorWithPriority>,
    Serializable {
        private static final long serialVersionUID = 1637460029437579033L;
        final Function<ConfigSourceInterceptorContext, ConfigSourceInterceptor> interceptor;
        final int priority;
        final String name;

        public ConfigSourceInterceptorWithPriority(SmallRyeConfigBuilder.InterceptorWithPriority interceptor) {
            this.interceptor = interceptor::getInterceptor;
            this.priority = interceptor.getPriority();
            this.name = "undefined";
        }

        public ConfigSourceInterceptorWithPriority(ConfigSource configSource) {
            this.interceptor = context -> SmallRyeConfigSourceInterceptor.configSourceInterceptor(configSource);
            this.priority = configSource.getOrdinal();
            this.name = configSource.getName();
        }

        public ConfigSourceInterceptorWithPriority(ConfigSourceInterceptor interceptor, int priority, String name) {
            this.interceptor = (Function<Object, Object> & Serializable)context -> interceptor;
            this.priority = priority;
            this.name = name;
        }

        public ConfigSourceInterceptor getInterceptor() {
            return this.interceptor.apply(null);
        }

        public ConfigSourceInterceptorWithPriority getInterceptor(ConfigSourceInterceptorContext context) {
            return new ConfigSourceInterceptorWithPriority(this.interceptor.apply(context), this.priority, this.name);
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(ConfigSourceInterceptorWithPriority other) {
            int res = Integer.compare(this.priority, other.priority);
            return res != 0 ? res : this.name.compareTo(other.name);
        }
    }

    private static class ConfigSources
    implements Serializable {
        private static final long serialVersionUID = 3483018375584151712L;
        private final List<ConfigSource> sources;
        private final List<ConfigSourceInterceptorWithPriority> interceptors;
        private final ConfigSourceInterceptorContext interceptorChain;

        ConfigSources(List<ConfigSource> sources, List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors) {
            ArrayList<ConfigSourceInterceptorWithPriority> sortInterceptors = new ArrayList<ConfigSourceInterceptorWithPriority>();
            sortInterceptors.addAll(sources.stream().filter(configSource -> !(configSource instanceof ConfigurableConfigSource)).map(ConfigSourceInterceptorWithPriority::new).collect(Collectors.toList()));
            sortInterceptors.addAll(interceptors.stream().map(ConfigSourceInterceptorWithPriority::new).collect(Collectors.toList()));
            sortInterceptors.sort(Comparator.comparingInt(ConfigSourceInterceptorWithPriority::getPriority));
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (ConfigSourceInterceptorWithPriority configSourceInterceptor : sortInterceptors) {
                ConfigSourceInterceptorWithPriority initInterceptor = configSourceInterceptor.getInterceptor(current);
                current = new SmallRyeConfigSourceInterceptorContext(initInterceptor.getInterceptor(), current);
            }
            final SmallRyeConfigSourceInterceptorContext initChain = current;
            List lateInitSources = sources.stream().filter(ConfigurableConfigSource.class::isInstance).map(ConfigurableConfigSource.class::cast).sorted(Comparator.comparingInt(ConfigurableConfigSource::getOrdinal)).collect(Collectors.toList());
            List lateInterceptors = lateInitSources.stream().flatMap(configurableConfigSource -> configurableConfigSource.getConfigSources(new ConfigSourceContext(){

                @Override
                public ConfigValue getValue(String name) {
                    return initChain.proceed(name);
                }

                @Override
                public Iterator<String> iterateNames() {
                    return initChain.iterateNames();
                }
            }).stream()).map(ConfigSourceInterceptorWithPriority::new).collect(Collectors.toList());
            sortInterceptors.addAll(lateInterceptors);
            sortInterceptors.sort(Comparator.comparingInt(ConfigSourceInterceptorWithPriority::getPriority));
            ArrayList<ConfigSourceInterceptorWithPriority> initInterceptors = new ArrayList<ConfigSourceInterceptorWithPriority>();
            current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (ConfigSourceInterceptorWithPriority configSourceInterceptor : sortInterceptors) {
                ConfigSourceInterceptorWithPriority initInterceptor = configSourceInterceptor.getInterceptor(current);
                current = new SmallRyeConfigSourceInterceptorContext(initInterceptor.getInterceptor(), current);
                initInterceptors.add(initInterceptor);
            }
            this.interceptorChain = current;
            this.sources = Collections.unmodifiableList(this.getSources(initInterceptors));
            this.interceptors = Collections.unmodifiableList(initInterceptors);
        }

        ConfigSources(ConfigSources sources, ConfigSource configSource) {
            int oldSize = sources.getInterceptors().size();
            List<ConfigSourceInterceptorWithPriority> newInterceptors = Arrays.asList(sources.getInterceptors().toArray(new ConfigSourceInterceptorWithPriority[oldSize + 1]));
            newInterceptors.set(oldSize, new ConfigSourceInterceptorWithPriority(configSource));
            newInterceptors.sort(Comparator.comparingInt(ConfigSourceInterceptorWithPriority::getPriority));
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (ConfigSourceInterceptorWithPriority configSourceInterceptor : newInterceptors) {
                ConfigSourceInterceptor interceptor = configSourceInterceptor.getInterceptor();
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current);
            }
            this.sources = Collections.unmodifiableList(this.getSources(newInterceptors));
            this.interceptors = Collections.unmodifiableList(newInterceptors);
            this.interceptorChain = current;
        }

        private List<ConfigSource> getSources(List<ConfigSourceInterceptorWithPriority> interceptors) {
            List<ConfigSource> sources = interceptors.stream().map(ConfigSourceInterceptorWithPriority::getInterceptor).filter(SmallRyeConfigSourceInterceptor.class::isInstance).map(SmallRyeConfigSourceInterceptor.class::cast).map(SmallRyeConfigSourceInterceptor::getSource).collect(Collectors.toList());
            Collections.reverse(sources);
            return sources;
        }

        List<ConfigSource> getSources() {
            return this.sources;
        }

        List<ConfigSourceInterceptorWithPriority> getInterceptors() {
            return this.interceptors;
        }

        ConfigSourceInterceptorContext getInterceptorChain() {
            return this.interceptorChain;
        }
    }
}

