/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Priority;

@Priority(value=3600)
public class ProfileConfigSourceInterceptor
implements ConfigSourceInterceptor {
    public static final String SMALLRYE_PROFILE = "smallrye.config.profile";
    private static final long serialVersionUID = -6305289277993917313L;
    private static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = (o1, o2) -> {
        int res = Integer.compare(o2.getConfigSourceOrdinal(), o1.getConfigSourceOrdinal());
        if (res != 0) {
            return res;
        }
        if (o1.getConfigSourceName() != null && o2.getConfigSourceName() != null) {
            return o2.getConfigSourceName().compareTo(o1.getConfigSourceName());
        }
        return res;
    };
    private final String profile;

    public ProfileConfigSourceInterceptor(String profile) {
        this.profile = profile;
    }

    public ProfileConfigSourceInterceptor(ConfigSourceInterceptorContext context) {
        this(context, SMALLRYE_PROFILE);
    }

    public ProfileConfigSourceInterceptor(ConfigSourceInterceptorContext context, String profileConfigName) {
        this.profile = Optional.ofNullable(context.proceed(profileConfigName)).map(ConfigValue::getValue).orElse(null);
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (this.profile != null) {
            String normalizeName = this.normalizeName(name);
            ConfigValue profileValue = context.proceed("%" + this.profile + "." + normalizeName);
            if (profileValue != null) {
                try {
                    ConfigValue originalValue = context.proceed(normalizeName);
                    if (originalValue != null && CONFIG_SOURCE_COMPARATOR.compare(profileValue, originalValue) > 0) {
                        return originalValue;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return profileValue.withName(normalizeName);
            }
        }
        return context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet names = new HashSet();
        context.iterateNames().forEachRemaining(name -> names.add(this.normalizeName((String)name)));
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet values = new HashSet();
        context.iterateValues().forEachRemaining(value -> values.add(value.withName(this.normalizeName(value.getName()))));
        return values.iterator();
    }

    private String normalizeName(String name) {
        return name.startsWith("%" + this.profile + ".") ? name.substring(this.profile.length() + 2) : name;
    }
}

