/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EnvConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    private static final int DEFAULT_ORDINAL = 300;
    private static final Object NULL_VALUE = new Object();
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    protected EnvConfigSource() {
        this(300);
    }

    protected EnvConfigSource(int ordinal) {
        this(EnvConfigSource.getEnvProperties(), ordinal);
    }

    public EnvConfigSource(Map<String, String> propertyMap, int ordinal) {
        super("EnvConfigSource", propertyMap, EnvConfigSource.getEnvOrdinal(propertyMap, ordinal));
    }

    public String getValue(String propertyName) {
        return EnvConfigSource.getValue(propertyName, this.getProperties(), this.cache);
    }

    private static String getValue(String name, Map<String, String> properties, Map<String, Object> cache) {
        if (name == null) {
            return null;
        }
        Object cachedValue = cache.get(name);
        if (cachedValue != null) {
            if (cachedValue == NULL_VALUE) {
                return null;
            }
            return (String)cachedValue;
        }
        String value = properties.get(name);
        if (value != null) {
            cache.put(name, value);
            return value;
        }
        String sanitizedName = EnvConfigSource.replaceNonAlphanumericByUnderscores(name);
        value = properties.get(sanitizedName);
        if (value != null) {
            cache.put(name, value);
            return value;
        }
        value = properties.get(sanitizedName.toUpperCase());
        if (value != null) {
            cache.put(name, value);
            return value;
        }
        cache.put(name, NULL_VALUE);
        return null;
    }

    private static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static Map<String, String> getEnvProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(() -> new HashMap<String, String>(System.getenv())));
    }

    private static int getEnvOrdinal(Map<String, String> properties, int ordinal) {
        String value = EnvConfigSource.getValue("config_ordinal", properties, new HashMap<String, Object>());
        if (value != null) {
            return (Integer)Converters.INTEGER_CONVERTER.convert(value);
        }
        return ordinal;
    }

    Object writeReplace() {
        return new Ser();
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6812312718645271331L;

        Ser() {
        }

        Object readResolve() {
            return new EnvConfigSource();
        }
    }
}

