/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.utils.StringUtil;

public class PropertyName {
    private final String name;

    public PropertyName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyName that = (PropertyName)o;
        return PropertyName.equals(this.name, that.name) || PropertyName.equals(that.name, this.name);
    }

    static boolean equals(String name, String other) {
        if (name == other) {
            return true;
        }
        if (name.equals("*") && (other.equals("") || other.equals("\"\""))) {
            return false;
        }
        int matchPosition = name.length() - 1;
        for (int i = other.length() - 1; i >= 0; --i) {
            if (matchPosition == -1) {
                return false;
            }
            char o = other.charAt(i);
            char n = name.charAt(matchPosition);
            if (n == '*') {
                if (o == ']') {
                    return false;
                }
                if (o == '\"') {
                    int beginQuote = other.lastIndexOf(34, i - 1);
                    if (beginQuote != -1) {
                        i = beginQuote;
                    }
                } else {
                    int previousDot = other.lastIndexOf(46, i);
                    i = previousDot != -1 ? previousDot + 1 : 0;
                }
            } else {
                if (n == ']' && o == ']') {
                    int range;
                    if (name.length() >= 3 && other.length() >= 3 && name.charAt(matchPosition - 1) == '*' && name.charAt(matchPosition - 2) == '[' && other.charAt(i - 1) == '*' && other.charAt(i - 2) == '[') {
                        matchPosition -= 2;
                        --i;
                        continue;
                    }
                    int beginIndexed = other.lastIndexOf(91, i);
                    if (beginIndexed != -1 && StringUtil.isNumeric((CharSequence)other, (int)(beginIndexed + (range = i - beginIndexed - 1)), (int)i)) {
                        matchPosition -= 3;
                        i = i - range - 1;
                        continue;
                    }
                    return false;
                }
                if (o != n) {
                    return false;
                }
            }
            --matchPosition;
        }
        return matchPosition <= 0;
    }

    public int hashCode() {
        int h = 0;
        int length = this.name.length();
        boolean quotesOpen = false;
        for (int i = 0; i < length; ++i) {
            char c = this.name.charAt(i);
            if (quotesOpen) {
                if (c != '\"') continue;
                quotesOpen = false;
                continue;
            }
            if (c == '\"') {
                quotesOpen = true;
                continue;
            }
            if (c != '.' && c != '[' && c != ']') continue;
            h = 31 * h + c;
        }
        return h;
    }

    public String toString() {
        return this.name;
    }

    public static PropertyName name(String name) {
        return new PropertyName(name);
    }
}

