/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public final class ConfigMappings
implements Serializable {
    private static final long serialVersionUID = -7790784345796818526L;
    private final ConcurrentMap<Class<?>, Map<String, ConfigMappingObject>> mappings = new ConcurrentHashMap();

    ConfigMappings() {
    }

    void registerConfigMappings(Map<Class<?>, Map<String, ConfigMappingObject>> mappings) {
        this.mappings.putAll(mappings);
    }

    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigMappingWithPrefix> mappings) throws ConfigValidationException {
        ConfigMappingProvider.Builder builder = ConfigMappingProvider.builder().validateUnknown(false);
        for (ConfigMappingWithPrefix mapping : mappings) {
            builder.addRoot(mapping.getPrefix(), mapping.getKlass());
        }
        ConfigMappings.registerConfigMappings(config, builder.build());
    }

    public static void registerConfigMappings(SmallRyeConfig config, ConfigMappingProvider mappingProvider) throws ConfigValidationException {
        for (ConfigSource configSource : config.getConfigSources()) {
            if (!(configSource instanceof DefaultValuesConfigSource)) continue;
            DefaultValuesConfigSource defaultValuesConfigSource = (DefaultValuesConfigSource)configSource;
            defaultValuesConfigSource.registerDefaults(mappingProvider.getDefaultValues());
        }
        mappingProvider.mapConfiguration(config);
    }

    <T> T getConfigMapping(Class<T> type) {
        String prefix = Optional.ofNullable(type.getAnnotation(ConfigMapping.class)).map(ConfigMapping::prefix).orElseGet(() -> Optional.ofNullable(type.getAnnotation(ConfigProperties.class)).map(ConfigProperties::prefix).orElse(""));
        return this.getConfigMapping(type, prefix);
    }

    <T> T getConfigMapping(Class<T> type, String prefix) {
        if (prefix == null) {
            return this.getConfigMapping(type);
        }
        Map mappingsForType = (Map)this.mappings.get(ConfigMappingLoader.getConfigMappingClass(type));
        if (mappingsForType == null) {
            throw ConfigMessages.msg.mappingNotFound(type.getName());
        }
        ConfigMappingObject configMappingObject = (ConfigMappingObject)mappingsForType.get(prefix);
        if (configMappingObject == null) {
            throw ConfigMessages.msg.mappingPrefixNotFound(type.getName(), prefix);
        }
        if (configMappingObject instanceof ConfigMappingClassMapper) {
            return type.cast(((ConfigMappingClassMapper)((Object)configMappingObject)).map());
        }
        return type.cast(configMappingObject);
    }

    static String getPrefix(Class<?> type) {
        ConfigMapping configMapping = type.getAnnotation(ConfigMapping.class);
        return configMapping != null ? configMapping.prefix() : "";
    }

    public static final class ConfigMappingWithPrefix {
        private final Class<?> klass;
        private final String prefix;

        public ConfigMappingWithPrefix(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public static ConfigMappingWithPrefix configMappingWithPrefix(Class<?> klass, String prefix) {
            return new ConfigMappingWithPrefix(klass, prefix);
        }
    }
}

