/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.vertx;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.util.Optional;

public class ContextLocals {
    private ContextLocals() {
    }

    private static ContextInternal ensureDuplicatedContext() {
        Context current = Vertx.currentContext();
        if (current == null || !VertxContext.isDuplicatedContext(current)) {
            throw new UnsupportedOperationException("Access to Context Locals are forbidden from a 'root' context  as it can leak data between unrelated processing. Make sure the method runs on a 'duplicated' (local) Context");
        }
        return (ContextInternal)current;
    }

    public static <T> Optional<T> get(String key) {
        ContextInternal current = ContextLocals.ensureDuplicatedContext();
        return Optional.ofNullable(current.getLocal(Assert.checkNotNullParam((String)"key", (Object)key)));
    }

    public static <T> T get(String key, T def) {
        ContextInternal current = ContextLocals.ensureDuplicatedContext();
        Object local = current.getLocal(Assert.checkNotNullParam((String)"key", (Object)key));
        if (local == null) {
            return def;
        }
        return (T)local;
    }

    public static <T> void put(String key, T value) {
        ContextInternal current = ContextLocals.ensureDuplicatedContext();
        current.putLocal(Assert.checkNotNullParam((String)"key", (Object)key), Assert.checkNotNullParam((String)"value", value));
    }

    public static boolean remove(String key) {
        ContextInternal current = ContextLocals.ensureDuplicatedContext();
        return current.removeLocal(Assert.checkNotNullParam((String)"key", (Object)key));
    }

    public static Context getParentContext() {
        ContextInternal current = ContextLocals.ensureDuplicatedContext();
        return (Context)current.getLocal((Object)"__PARENT_CONTEXT__");
    }

    public static <T> boolean putInParent(String key, T value) {
        ContextLocals.ensureDuplicatedContext();
        String k = (String)Assert.checkNotNullParam((String)"key", (Object)key);
        Object v = Assert.checkNotNullParam((String)"value", value);
        Context parent = ContextLocals.getParentContext();
        if (parent == null) {
            throw new IllegalStateException("Parent context is not set");
        }
        if (VertxContext.isDuplicatedContext(parent)) {
            return ((ContextInternal)parent).localContextData().putIfAbsent(k, v) == null;
        }
        throw new IllegalStateException("The parent context is a root context");
    }

    public static <T> Optional<T> getFromParent(String key) {
        String k = (String)Assert.checkNotNullParam((String)"key", (Object)key);
        Context parent = ContextLocals.getParentContext();
        if (parent == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(parent.getLocal((Object)k));
    }

    public static <T> T getFromParent(String key, T def) {
        String k = (String)Assert.checkNotNullParam((String)"key", (Object)key);
        Context parent = ContextLocals.getParentContext();
        if (parent == null) {
            return def;
        }
        Object local = parent.getLocal((Object)k);
        if (local == null) {
            return def;
        }
        return (T)local;
    }
}

