/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.constantpool.InvokeDynamicEntry;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InvokeDynamicInstruction
extends Instruction {
    public InvokeDynamicEntry invokedynamic();

    default public Utf8Entry name() {
        return this.invokedynamic().name();
    }

    default public Utf8Entry type() {
        return this.invokedynamic().type();
    }

    default public MethodTypeDesc typeSymbol() {
        return this.invokedynamic().typeSymbol();
    }

    default public DirectMethodHandleDesc bootstrapMethod() {
        return this.invokedynamic().bootstrap().bootstrapMethod().asSymbol();
    }

    default public List<ConstantDesc> bootstrapArgs() {
        return Util.mappedList(this.invokedynamic().bootstrap().arguments(), new Function<LoadableConstantEntry, ConstantDesc>(){

            @Override
            public ConstantDesc apply(LoadableConstantEntry loadableConstantEntry) {
                return loadableConstantEntry.constantValue();
            }
        });
    }

    public static InvokeDynamicInstruction of(InvokeDynamicEntry invokedynamic) {
        return new AbstractInstruction.UnboundInvokeDynamicInstruction(invokedynamic);
    }
}

