/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationElement;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.constantpool.DoubleEntry;
import io.smallrye.classfile.constantpool.FloatEntry;
import io.smallrye.classfile.constantpool.IntegerEntry;
import io.smallrye.classfile.constantpool.LongEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AnnotationImpl;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.LabelContext;
import io.smallrye.classfile.impl.UnboundAttribute;
import java.util.List;

public final class AnnotationReader {
    private AnnotationReader() {
    }

    public static List<Annotation> readAnnotations(ClassReader classReader, int p) {
        int pos = p;
        int numAnnotations = classReader.readU2(pos);
        Annotation[] annos = new Annotation[numAnnotations];
        pos += 2;
        for (int i = 0; i < numAnnotations; ++i) {
            annos[i] = AnnotationReader.readAnnotation(classReader, pos);
            pos = AnnotationReader.skipAnnotation(classReader, pos);
        }
        return List.of(annos);
    }

    public static AnnotationValue readElementValue(ClassReader classReader, int p) {
        char tag = (char)classReader.readU1(p);
        ++p;
        return switch (tag) {
            case 'B' -> new AnnotationImpl.OfByteImpl(classReader.readEntry(p, IntegerEntry.class));
            case 'C' -> new AnnotationImpl.OfCharImpl(classReader.readEntry(p, IntegerEntry.class));
            case 'D' -> new AnnotationImpl.OfDoubleImpl(classReader.readEntry(p, DoubleEntry.class));
            case 'F' -> new AnnotationImpl.OfFloatImpl(classReader.readEntry(p, FloatEntry.class));
            case 'I' -> new AnnotationImpl.OfIntImpl(classReader.readEntry(p, IntegerEntry.class));
            case 'J' -> new AnnotationImpl.OfLongImpl(classReader.readEntry(p, LongEntry.class));
            case 'S' -> new AnnotationImpl.OfShortImpl(classReader.readEntry(p, IntegerEntry.class));
            case 'Z' -> new AnnotationImpl.OfBooleanImpl(classReader.readEntry(p, IntegerEntry.class));
            case 's' -> new AnnotationImpl.OfStringImpl(classReader.readEntry(p, Utf8Entry.class));
            case 'e' -> new AnnotationImpl.OfEnumImpl(classReader.readEntry(p, Utf8Entry.class), classReader.readEntry(p + 2, Utf8Entry.class));
            case 'c' -> new AnnotationImpl.OfClassImpl(classReader.readEntry(p, Utf8Entry.class));
            case '@' -> new AnnotationImpl.OfAnnotationImpl(AnnotationReader.readAnnotation(classReader, p));
            case '[' -> {
                int numValues = classReader.readU2(p);
                p += 2;
                AnnotationValue[] values = new AnnotationValue[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = AnnotationReader.readElementValue(classReader, p);
                    p = AnnotationReader.skipElementValue(classReader, p);
                }
                yield new AnnotationImpl.OfArrayImpl(List.of(values));
            }
            default -> throw new IllegalArgumentException("Unexpected tag '%s' in AnnotationValue, pos = %d".formatted(Character.valueOf(tag), p - 1));
        };
    }

    public static List<TypeAnnotation> readTypeAnnotations(ClassReader classReader, int p, LabelContext lc) {
        int numTypeAnnotations = classReader.readU2(p);
        p += 2;
        TypeAnnotation[] annotations = new TypeAnnotation[numTypeAnnotations];
        for (int i = 0; i < numTypeAnnotations; ++i) {
            annotations[i] = AnnotationReader.readTypeAnnotation(classReader, p, lc);
            p = AnnotationReader.skipTypeAnnotation(classReader, p);
        }
        return List.of(annotations);
    }

    public static List<List<Annotation>> readParameterAnnotations(ClassReader classReader, int p) {
        int cnt = classReader.readU1(p++);
        Object[] pas = new Object[cnt];
        for (int i = 0; i < cnt; ++i) {
            pas[i] = AnnotationReader.readAnnotations(classReader, p);
            p = AnnotationReader.skipAnnotations(classReader, p);
        }
        return List.of(pas);
    }

    private static int skipElementValue(ClassReader classReader, int p) {
        char tag = (char)classReader.readU1(p);
        ++p;
        return switch (tag) {
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z', 'c', 's' -> p + 2;
            case 'e' -> p + 4;
            case '@' -> AnnotationReader.skipAnnotation(classReader, p);
            case '[' -> {
                int numValues = classReader.readU2(p);
                p += 2;
                for (int i = 0; i < numValues; ++i) {
                    p = AnnotationReader.skipElementValue(classReader, p);
                }
                yield p;
            }
            default -> throw new IllegalArgumentException("Unexpected tag '%s' in AnnotationValue, pos = %d".formatted(Character.valueOf(tag), p - 1));
        };
    }

    private static Annotation readAnnotation(ClassReader classReader, int p) {
        Utf8Entry annotationClass = classReader.readEntry(p, Utf8Entry.class);
        List<AnnotationElement> elems = AnnotationReader.readAnnotationElementValuePairs(classReader, p += 2);
        return new AnnotationImpl(annotationClass, elems);
    }

    private static int skipAnnotations(ClassReader classReader, int p) {
        int numAnnotations = classReader.readU2(p);
        p += 2;
        for (int i = 0; i < numAnnotations; ++i) {
            p = AnnotationReader.skipAnnotation(classReader, p);
        }
        return p;
    }

    private static int skipAnnotation(ClassReader classReader, int p) {
        return AnnotationReader.skipElementValuePairs(classReader, p + 2);
    }

    private static List<AnnotationElement> readAnnotationElementValuePairs(ClassReader classReader, int p) {
        int numElementValuePairs = classReader.readU2(p);
        p += 2;
        AnnotationElement[] annotationElements = new AnnotationElement[numElementValuePairs];
        for (int i = 0; i < numElementValuePairs; ++i) {
            Utf8Entry elementName = classReader.readEntry(p, Utf8Entry.class);
            AnnotationValue value = AnnotationReader.readElementValue(classReader, p += 2);
            annotationElements[i] = new AnnotationImpl.AnnotationElementImpl(elementName, value);
            p = AnnotationReader.skipElementValue(classReader, p);
        }
        return List.of(annotationElements);
    }

    private static int skipElementValuePairs(ClassReader classReader, int p) {
        int numElementValuePairs = classReader.readU2(p);
        p += 2;
        for (int i = 0; i < numElementValuePairs; ++i) {
            p = AnnotationReader.skipElementValue(classReader, p + 2);
        }
        return p;
    }

    private static Label getLabel(LabelContext lc, int bciOffset, int targetType, int p) {
        if (lc == null) {
            throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation outside of Code attribute, pos = %d".formatted(targetType, p - 1));
        }
        return lc.getLabel(bciOffset);
    }

    private static TypeAnnotation readTypeAnnotation(ClassReader classReader, int p, LabelContext lc) {
        int targetType = classReader.readU1(p++);
        TypeAnnotation.EmptyTarget targetInfo = switch (targetType) {
            case 0 -> TypeAnnotation.TargetInfo.ofClassTypeParameter(classReader.readU1(p));
            case 1 -> TypeAnnotation.TargetInfo.ofMethodTypeParameter(classReader.readU1(p));
            case 16 -> TypeAnnotation.TargetInfo.ofClassExtends(classReader.readU2(p));
            case 17 -> TypeAnnotation.TargetInfo.ofClassTypeParameterBound(classReader.readU1(p), classReader.readU1(p + 1));
            case 18 -> TypeAnnotation.TargetInfo.ofMethodTypeParameterBound(classReader.readU1(p), classReader.readU1(p + 1));
            case 19 -> TypeAnnotation.TargetInfo.ofField();
            case 20 -> TypeAnnotation.TargetInfo.ofMethodReturn();
            case 21 -> TypeAnnotation.TargetInfo.ofMethodReceiver();
            case 22 -> TypeAnnotation.TargetInfo.ofMethodFormalParameter(classReader.readU1(p));
            case 23 -> TypeAnnotation.TargetInfo.ofThrows(classReader.readU2(p));
            case 64 -> TypeAnnotation.TargetInfo.ofLocalVariable(AnnotationReader.readLocalVarEntries(classReader, p, lc, targetType));
            case 65 -> TypeAnnotation.TargetInfo.ofResourceVariable(AnnotationReader.readLocalVarEntries(classReader, p, lc, targetType));
            case 66 -> TypeAnnotation.TargetInfo.ofExceptionParameter(classReader.readU2(p));
            case 67 -> TypeAnnotation.TargetInfo.ofInstanceofExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 68 -> TypeAnnotation.TargetInfo.ofNewExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 69 -> TypeAnnotation.TargetInfo.ofConstructorReference(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 70 -> TypeAnnotation.TargetInfo.ofMethodReference(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 71 -> TypeAnnotation.TargetInfo.ofCastExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 72 -> TypeAnnotation.TargetInfo.ofConstructorInvocationTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 73 -> TypeAnnotation.TargetInfo.ofMethodInvocationTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 74 -> TypeAnnotation.TargetInfo.ofConstructorReferenceTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 75 -> TypeAnnotation.TargetInfo.ofMethodReferenceTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            default -> throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation, pos = %d".formatted(targetType, p - 1));
        };
        p += targetInfo.size();
        int pathLength = classReader.readU1(p++);
        TypeAnnotation.TypePathComponent[] typePath = new TypeAnnotation.TypePathComponent[pathLength];
        for (int i = 0; i < pathLength; ++i) {
            int typePathKindTag = classReader.readU1(p++);
            int typeArgumentIndex = classReader.readU1(p++);
            typePath[i] = switch (typePathKindTag) {
                case 0 -> TypeAnnotation.TypePathComponent.ARRAY;
                case 1 -> TypeAnnotation.TypePathComponent.INNER_TYPE;
                case 2 -> TypeAnnotation.TypePathComponent.WILDCARD;
                case 3 -> new UnboundAttribute.TypePathComponentImpl(TypeAnnotation.TypePathComponent.Kind.TYPE_ARGUMENT, typeArgumentIndex);
                default -> throw new IllegalArgumentException("Unknown type annotation path component kind: " + typePathKindTag);
            };
        }
        Annotation anno = AnnotationReader.readAnnotation(classReader, p);
        return TypeAnnotation.of(targetInfo, List.of(typePath), anno);
    }

    private static List<TypeAnnotation.LocalVarTargetInfo> readLocalVarEntries(ClassReader classReader, int p, LabelContext lc, int targetType) {
        int tableLength = classReader.readU2(p);
        p += 2;
        TypeAnnotation.LocalVarTargetInfo[] entries = new TypeAnnotation.LocalVarTargetInfo[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            int startPc = classReader.readU2(p);
            entries[i] = TypeAnnotation.LocalVarTargetInfo.of(AnnotationReader.getLabel(lc, startPc, targetType, p), AnnotationReader.getLabel(lc, startPc + classReader.readU2(p + 2), targetType, p - 2), classReader.readU2(p + 4));
            p += 6;
        }
        return List.of(entries);
    }

    private static int skipTypeAnnotation(ClassReader classReader, int p) {
        int targetType = classReader.readU1(p++);
        p += (switch (targetType) {
            case 19, 20, 21 -> 0;
            case 0, 1, 22 -> 1;
            case 16, 17, 18, 23, 66, 67, 68, 69, 70 -> 2;
            case 71, 72, 73, 74, 75 -> 3;
            case 64, 65 -> 2 + classReader.readU2(p) * 6;
            default -> throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation, pos = %d".formatted(targetType, p - 1));
        });
        int pathLength = classReader.readU1(p++);
        p += pathLength * 2;
        p += 2;
        p = AnnotationReader.skipElementValuePairs(classReader, p);
        return p;
    }

    public static void writeAnnotation(BufWriterImpl buf, Annotation annotation) {
        List<AnnotationElement> elements = annotation.elements();
        buf.writeU2U2(buf.cpIndex(annotation.className()), elements.size());
        for (AnnotationElement e : elements) {
            buf.writeIndex(e.name());
            AnnotationReader.writeAnnotationValue(buf, e.value());
        }
    }

    public static void writeAnnotations(BufWriter buf, List<Annotation> list) {
        BufWriterImpl internalBuf = (BufWriterImpl)buf;
        internalBuf.writeU2(list.size());
        for (Annotation e : list) {
            AnnotationReader.writeAnnotation(internalBuf, e);
        }
    }

    private static int labelToBci(LabelContext lr, Label label, TypeAnnotation ta) {
        if (lr == null) {
            throw new IllegalArgumentException("Illegal targetType '%s' in TypeAnnotation outside of Code attribute".formatted(new Object[]{ta.targetInfo().targetType()}));
        }
        return lr.labelToBci(label);
    }

    public static void writeTypeAnnotation(BufWriterImpl buf, TypeAnnotation ta) {
        LabelContext lr = buf.labelContext();
        buf.writeU1(ta.targetInfo().targetType().targetTypeValue());
        Object object = ta.targetInfo();
        if (object instanceof TypeAnnotation.TypeParameterTarget) {
            TypeAnnotation.TypeParameterTarget tpt = (TypeAnnotation.TypeParameterTarget)object;
            buf.writeU1(tpt.typeParameterIndex());
        } else {
            object = ta.targetInfo();
            if (object instanceof TypeAnnotation.SupertypeTarget) {
                TypeAnnotation.SupertypeTarget st = (TypeAnnotation.SupertypeTarget)object;
                buf.writeU2(st.supertypeIndex());
            } else {
                object = ta.targetInfo();
                if (object instanceof TypeAnnotation.TypeParameterBoundTarget) {
                    TypeAnnotation.TypeParameterBoundTarget tpbt = (TypeAnnotation.TypeParameterBoundTarget)object;
                    buf.writeU1U1(tpbt.typeParameterIndex(), tpbt.boundIndex());
                } else if (!(ta.targetInfo() instanceof TypeAnnotation.EmptyTarget)) {
                    object = ta.targetInfo();
                    if (object instanceof TypeAnnotation.FormalParameterTarget) {
                        TypeAnnotation.FormalParameterTarget fpt = (TypeAnnotation.FormalParameterTarget)object;
                        buf.writeU1(fpt.formalParameterIndex());
                    } else {
                        object = ta.targetInfo();
                        if (object instanceof TypeAnnotation.ThrowsTarget) {
                            TypeAnnotation.ThrowsTarget tt = (TypeAnnotation.ThrowsTarget)object;
                            buf.writeU2(tt.throwsTargetIndex());
                        } else {
                            object = ta.targetInfo();
                            if (object instanceof TypeAnnotation.LocalVarTarget) {
                                TypeAnnotation.LocalVarTarget lvt = (TypeAnnotation.LocalVarTarget)object;
                                buf.writeU2(lvt.table().size());
                                for (TypeAnnotation.LocalVarTargetInfo e : lvt.table()) {
                                    int startPc = AnnotationReader.labelToBci(lr, e.startLabel(), ta);
                                    buf.writeU2U2U2(startPc, AnnotationReader.labelToBci(lr, e.endLabel(), ta) - startPc, e.index());
                                }
                            } else {
                                object = ta.targetInfo();
                                if (object instanceof TypeAnnotation.CatchTarget) {
                                    TypeAnnotation.CatchTarget ct = (TypeAnnotation.CatchTarget)object;
                                    buf.writeU2(ct.exceptionTableIndex());
                                } else {
                                    object = ta.targetInfo();
                                    if (object instanceof TypeAnnotation.OffsetTarget) {
                                        TypeAnnotation.OffsetTarget ot = (TypeAnnotation.OffsetTarget)object;
                                        buf.writeU2(AnnotationReader.labelToBci(lr, ot.target(), ta));
                                    } else {
                                        object = ta.targetInfo();
                                        if (object instanceof TypeAnnotation.TypeArgumentTarget) {
                                            TypeAnnotation.TypeArgumentTarget tat = (TypeAnnotation.TypeArgumentTarget)object;
                                            buf.writeU2U1(AnnotationReader.labelToBci(lr, tat.target(), ta), tat.typeArgumentIndex());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        buf.writeU1(ta.targetPath().size());
        for (TypeAnnotation.TypePathComponent component : ta.targetPath()) {
            buf.writeU1U1(component.typePathKind().tag(), component.typeArgumentIndex());
        }
        AnnotationReader.writeAnnotation(buf, ta.annotation());
    }

    public static void writeTypeAnnotations(BufWriter buf, List<TypeAnnotation> list) {
        BufWriterImpl internalBuf = (BufWriterImpl)buf;
        internalBuf.writeU2(list.size());
        for (TypeAnnotation e : list) {
            AnnotationReader.writeTypeAnnotation(internalBuf, e);
        }
    }

    public static void writeAnnotationValue(BufWriterImpl buf, AnnotationValue value) {
        int tag = value.tag();
        buf.writeU1(tag);
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                buf.writeIndex(((AnnotationValue.OfConstant)value).constant());
                break;
            }
            case 99: {
                buf.writeIndex(((AnnotationValue.OfClass)value).className());
                break;
            }
            case 101: {
                AnnotationValue.OfEnum enumValue = (AnnotationValue.OfEnum)value;
                buf.writeIndex(enumValue.className());
                buf.writeIndex(enumValue.constantName());
                break;
            }
            case 64: {
                AnnotationReader.writeAnnotation(buf, ((AnnotationValue.OfAnnotation)value).annotation());
                break;
            }
            case 91: {
                List<AnnotationValue> array = ((AnnotationValue.OfArray)value).values();
                buf.writeU2(array.size());
                for (AnnotationValue e : array) {
                    AnnotationReader.writeAnnotationValue(buf, e);
                }
                break;
            }
            default: {
                throw new InternalError("Unknown value " + String.valueOf(value));
            }
        }
    }
}

