/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.impl.AttributeHolder;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.Util;

public class AbstractDirectBuilder<M> {
    protected final SplitConstantPool constantPool;
    protected final ClassFileImpl context;
    protected final AttributeHolder attributes = new AttributeHolder();
    protected M original;

    public AbstractDirectBuilder(SplitConstantPool constantPool, ClassFileImpl context) {
        this.constantPool = constantPool;
        this.context = context;
    }

    public SplitConstantPool constantPool() {
        return this.constantPool;
    }

    public boolean canWriteDirect(ConstantPool source) {
        return this.constantPool().canWriteDirect(source);
    }

    public void setOriginal(M original) {
        this.original = original;
    }

    public void writeAttribute(Attribute<?> a) {
        if (Util.isAttributeAllowed(a, this.context)) {
            this.attributes.withAttribute(a);
        }
    }
}

