/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.attribute.ModuleHashInfo;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleHashesAttribute
extends Attribute<ModuleHashesAttribute>,
ClassElement {
    public Utf8Entry algorithm();

    public List<ModuleHashInfo> hashes();

    public static ModuleHashesAttribute of(String algorithm, List<ModuleHashInfo> hashes) {
        return ModuleHashesAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(algorithm), hashes);
    }

    public static ModuleHashesAttribute of(String algorithm, ModuleHashInfo ... hashes) {
        return ModuleHashesAttribute.of(algorithm, List.of(hashes));
    }

    public static ModuleHashesAttribute of(Utf8Entry algorithm, List<ModuleHashInfo> hashes) {
        return new UnboundAttribute.UnboundModuleHashesAttribute(algorithm, hashes);
    }

    public static ModuleHashesAttribute of(Utf8Entry algorithm, ModuleHashInfo ... hashes) {
        return ModuleHashesAttribute.of(algorithm, List.of(hashes));
    }
}

