/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.FieldElement;
import io.smallrye.classfile.constantpool.ConstantValueEntry;
import io.smallrye.classfile.impl.BackportUtil;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import java.lang.constant.ConstantDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantValueAttribute
extends Attribute<ConstantValueAttribute>,
FieldElement {
    public ConstantValueEntry constant();

    public static ConstantValueAttribute of(ConstantValueEntry value) {
        return new UnboundAttribute.UnboundConstantValueAttribute(value);
    }

    public static ConstantValueAttribute of(ConstantDesc value) {
        ConstantValueEntry constantValueEntry;
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            constantValueEntry = TemporaryConstantPool.INSTANCE.intEntry(i);
        } else if (value instanceof Float) {
            Float f = (Float)value;
            constantValueEntry = TemporaryConstantPool.INSTANCE.floatEntry(f.floatValue());
        } else if (value instanceof Long) {
            Long l = (Long)value;
            constantValueEntry = TemporaryConstantPool.INSTANCE.longEntry(l);
        } else if (value instanceof Double) {
            Double d = (Double)value;
            constantValueEntry = TemporaryConstantPool.INSTANCE.doubleEntry(d);
        } else if (value instanceof String) {
            String s = (String)((Object)value);
            constantValueEntry = TemporaryConstantPool.INSTANCE.stringEntry(s);
        } else {
            constantValueEntry = (ConstantValueEntry)BackportUtil.throwAsObj(IllegalArgumentException::new, "Invalid ConstantValueAttribute value: " + String.valueOf(value));
        }
        return ConstantValueAttribute.of(constantValueEntry);
    }
}

