/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.components.ClassPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CompoundElement<E extends ClassFileElement>
extends ClassFileElement,
Iterable<E> {
    @Override
    public void forEach(Consumer<? super E> var1);

    @Override
    default public Iterator<E> iterator() {
        return this.elementList().iterator();
    }

    default public Stream<E> elementStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
    }

    default public List<E> elementList() {
        final ArrayList list = new ArrayList();
        this.forEach(new Consumer<E>(){

            @Override
            public void accept(E e) {
                list.add(e);
            }
        });
        return Collections.unmodifiableList(list);
    }

    default public String toDebugString() {
        StringBuilder text = new StringBuilder();
        ClassPrinter.toYaml(this, ClassPrinter.Verbosity.TRACE_ALL, text::append);
        return text.toString();
    }
}

