/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.ClassFileTransform;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeElement;
import io.smallrye.classfile.impl.TransformImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

@FunctionalInterface
public interface CodeTransform
extends ClassFileTransform<CodeTransform, CodeElement, CodeBuilder> {
    public static final CodeTransform ACCEPT_ALL = new CodeTransform(){

        @Override
        public void accept(CodeBuilder builder, CodeElement element) {
            builder.with(element);
        }
    };

    public static CodeTransform ofStateful(Supplier<CodeTransform> supplier) {
        return new TransformImpl.SupplierCodeTransform(Objects.requireNonNull(supplier));
    }

    public static CodeTransform endHandler(final Consumer<CodeBuilder> finisher) {
        Objects.requireNonNull(finisher);
        return new CodeTransform(){

            @Override
            public void accept(CodeBuilder builder, CodeElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(CodeBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    @Override
    default public CodeTransform andThen(CodeTransform t) {
        return new TransformImpl.ChainedCodeTransform(this, Objects.requireNonNull(t));
    }
}

