/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.common.constraint.Assert;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class Util {
    private Util() {
    }

    public static <R, T> List<R> mapList(List<T> input, Function<T, R> mapper, IntFunction<R[]> generator) {
        Assert.checkNotNullParam((String)"input", input);
        Assert.checkNotNullParam((String)"mapper", mapper);
        int size = input.size();
        switch (size) {
            case 0: {
                return List.of();
            }
            case 1: {
                return List.of(mapper.apply(input.get(0)));
            }
            case 2: {
                return List.of(mapper.apply(input.get(0)), mapper.apply(input.get(1)));
            }
            case 3: {
                return List.of(mapper.apply(input.get(0)), mapper.apply(input.get(1)), mapper.apply(input.get(2)));
            }
        }
        R[] array = generator.apply(size);
        for (int i = 0; i < size; ++i) {
            array[i] = mapper.apply(input.get(i));
        }
        return List.of(array);
    }
}

