/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanDefinition;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.ConstructorSupplier;
import io.smallrye.beanbag.DependencyFilter;
import io.smallrye.beanbag.InjectingSupplier;
import io.smallrye.beanbag.Injector;
import io.smallrye.beanbag.Scope;
import io.smallrye.beanbag.ScopeDefinition;
import io.smallrye.common.constraint.Assert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class BeanBag {
    private final Scope singletonScope;
    private final ScopeDefinition scopeDefinition;

    BeanBag(Builder builder) {
        ArrayList definitions = new ArrayList();
        ArrayList singletonBeans = new ArrayList();
        for (BeanBuilder<?> beanBuilder : builder.beanBuilders) {
            this.addDefinitionsTo(beanBuilder, beanBuilder.singleton ? singletonBeans : definitions);
        }
        ScopeDefinition scopeDefinition = new ScopeDefinition(List.copyOf(definitions));
        this.singletonScope = new Scope(this, null, scopeDefinition, new ScopeDefinition(singletonBeans));
        this.scopeDefinition = scopeDefinition;
    }

    private <T> void addDefinitionsTo(BeanBuilder<T> beanBuilder, List<BeanDefinition<?>> definitions) {
        String name = beanBuilder.name;
        Set<String> aliases = beanBuilder.aliases;
        Set restrictedTypes = Set.copyOf(Objects.requireNonNullElse(beanBuilder.restrictedTypes, List.of()));
        BeanSupplier supplier = beanBuilder.supplier;
        int priority = beanBuilder.priority;
        Class type = beanBuilder.type;
        BeanDefinition definition = new BeanDefinition(name, priority, type, restrictedTypes, supplier);
        definitions.add(definition);
        if (aliases != null) {
            for (String alias : aliases) {
                definitions.add(new BeanDefinition<Object>(alias, priority, type, restrictedTypes, scope -> scope.requireBean(definition)));
            }
        }
    }

    public Scope newScope() {
        return new Scope(this, this.singletonScope, null, this.scopeDefinition);
    }

    public <T> List<T> getAllBeans(Class<T> type) {
        return this.newScope().getAllBeans(type);
    }

    public <T> T requireBean(Class<T> type) {
        return this.newScope().requireBean(type);
    }

    public <T> T requireBean(Class<T> type, String name) {
        return this.newScope().requireBean(type, name);
    }

    public <T> T getOptionalBean(Class<T> type) {
        return this.newScope().getOptionalBean(type);
    }

    public <T> T getOptionalBean(Class<T> type, String name) {
        return this.newScope().getOptionalBean(type, name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class SupplierBuilder<T> {
        private final BeanBuilder<T> beanBuilder;
        private final List<BeanSupplier<?>> argumentSuppliers = new ArrayList();
        private Constructor<T> constructor;
        private List<Injector<T>> injectors;

        SupplierBuilder(BeanBuilder<T> beanBuilder) {
            this.beanBuilder = beanBuilder;
        }

        public SupplierBuilder<T> setConstructor(Constructor<T> constructor) {
            Assert.checkNotNullParam((String)"constructor", constructor);
            this.constructor = constructor;
            return this;
        }

        private List<Injector<T>> getInjectorList() {
            List<Injector<T>> injectors = this.injectors;
            if (injectors == null) {
                this.injectors = new ArrayList<Injector<T>>();
                return this.injectors;
            }
            return injectors;
        }

        public SupplierBuilder<T> injectField(Field field, BeanSupplier<?> supplier) {
            this.getInjectorList().add(Injector.forField((Field)Assert.checkNotNullParam((String)"field", (Object)field), (BeanSupplier)Assert.checkNotNullParam((String)"supplier", supplier)));
            return this;
        }

        public SupplierBuilder<T> injectField(Field field, Class<?> injectType, String beanName, boolean optional, DependencyFilter filter) {
            return this.injectField(field, BeanSupplier.resolving(injectType, beanName, optional, filter));
        }

        public SupplierBuilder<T> injectField(Field field) {
            return this.injectField(field, "");
        }

        public SupplierBuilder<T> injectField(Field field, String beanName) {
            return this.injectField(field, beanName, false);
        }

        public SupplierBuilder<T> injectField(Field field, boolean optional) {
            return this.injectField(field, "", optional);
        }

        public SupplierBuilder<T> injectField(Field field, String beanName, boolean optional) {
            return this.injectField(field, beanName, optional, DependencyFilter.ACCEPT);
        }

        public SupplierBuilder<T> injectField(Field field, String beanName, boolean optional, DependencyFilter filter) {
            return this.injectField((Field)Assert.checkNotNullParam((String)"field", (Object)field), field.getType(), beanName, optional, filter);
        }

        public SupplierBuilder<T> injectMethod(Method method, BeanSupplier<?> supplier) {
            this.getInjectorList().add(Injector.forSetterMethod((Method)Assert.checkNotNullParam((String)"method", (Object)method), supplier));
            return this;
        }

        public SupplierBuilder<T> injectMethod(Method method, Class<?> injectType, String beanName, boolean optional, DependencyFilter filter) {
            return this.injectMethod(method, BeanSupplier.resolving(injectType, beanName, optional, filter));
        }

        public SupplierBuilder<T> injectMethod(Method method) {
            return this.injectMethod(method, "");
        }

        public SupplierBuilder<T> injectMethod(Method method, String beanName) {
            return this.injectMethod(method, beanName, false);
        }

        public SupplierBuilder<T> injectMethod(Method method, boolean optional) {
            return this.injectMethod(method, "", optional);
        }

        public SupplierBuilder<T> injectMethod(Method method, String beanName, boolean optional) {
            return this.injectMethod((Method)Assert.checkNotNullParam((String)"method", (Object)method), beanName, optional, DependencyFilter.ACCEPT);
        }

        public SupplierBuilder<T> injectMethod(Method method, String beanName, boolean optional, DependencyFilter filter) {
            return this.injectMethod((Method)Assert.checkNotNullParam((String)"method", (Object)method), method.getParameterTypes()[0], beanName, optional, filter);
        }

        public SupplierBuilder<T> addConstructorArgument(BeanSupplier<?> supplier) {
            this.argumentSuppliers.add((BeanSupplier)Assert.checkNotNullParam((String)"supplier", supplier));
            return this;
        }

        public SupplierBuilder<T> addConstructorArgument(Class<?> injectType) {
            return this.addConstructorArgument(injectType, false);
        }

        public SupplierBuilder<T> addConstructorArgument(Class<?> injectType, boolean optional) {
            return this.addConstructorArgument(injectType, "", optional);
        }

        public SupplierBuilder<T> addConstructorArgument(Class<?> injectType, String beanName) {
            return this.addConstructorArgument(injectType, beanName, false);
        }

        public SupplierBuilder<T> addConstructorArgument(Class<?> injectType, String beanName, boolean optional) {
            return this.addConstructorArgument(injectType, beanName, optional, DependencyFilter.ACCEPT);
        }

        public SupplierBuilder<T> addConstructorArgument(Class<?> injectType, String beanName, boolean optional, DependencyFilter filter) {
            return this.addConstructorArgument(BeanSupplier.resolving(injectType, beanName, optional, filter));
        }

        public BeanBuilder<T> build() {
            BeanSupplier supplier = new ConstructorSupplier((Constructor)Assert.checkNotNullParam((String)"constructor", this.constructor), this.argumentSuppliers);
            List<Injector<T>> injectors = this.injectors;
            if (injectors != null) {
                supplier = new InjectingSupplier(supplier, List.copyOf(injectors));
            }
            this.beanBuilder.setSupplier(supplier);
            return this.beanBuilder;
        }
    }

    public static final class BeanBuilder<T> {
        private final Builder builder;
        private final Class<T> type;
        private int priority = 0;
        private List<Class<? super T>> restrictedTypes;
        private String name = "";
        private Set<String> aliases;
        private BeanSupplier<T> supplier;
        private boolean singleton;

        BeanBuilder(Builder builder, Class<T> type) {
            this.builder = builder;
            this.type = type;
        }

        public BeanBuilder<T> setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public BeanBuilder<T> setName(String name) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            this.name = name;
            return this;
        }

        public BeanBuilder<T> addAlias(String alias) {
            Assert.checkNotNullParam((String)"alias", (Object)alias);
            if (this.aliases == null) {
                this.aliases = new HashSet<String>();
            }
            this.aliases.add(alias);
            return this;
        }

        public BeanBuilder<T> setSupplier(BeanSupplier<T> supplier) {
            Assert.checkNotNullParam((String)"supplier", supplier);
            this.supplier = supplier;
            return this;
        }

        public BeanBuilder<T> setInstance(T instance) {
            Assert.checkNotNullParam((String)"instance", instance);
            this.supplier = scope -> instance;
            this.singleton = true;
            return this;
        }

        public SupplierBuilder<T> buildSupplier() {
            return new SupplierBuilder(this);
        }

        public BeanBuilder<T> setSingleton(boolean singleton) {
            this.singleton = singleton;
            return this;
        }

        public BeanBuilder<T> addRestrictedTypes(Collection<Class<? super T>> types) {
            Assert.checkNotNullParam((String)"types", types);
            if (this.restrictedTypes != null) {
                this.restrictedTypes.addAll(types);
            } else {
                this.restrictedTypes = new ArrayList<Class<T>>(types);
            }
            return this;
        }

        public Builder build() {
            this.builder.beanBuilders.add(this);
            return this.builder;
        }
    }

    public static final class Builder {
        private final List<BeanBuilder<?>> beanBuilders = new ArrayList();

        Builder() {
        }

        public <T> BeanBuilder<T> addBean(Class<T> type) {
            Assert.checkNotNullParam((String)"type", type);
            return new BeanBuilder<T>(this, type);
        }

        public <T> Builder addBeanInstance(T bean) {
            Assert.checkNotNullParam((String)"bean", bean);
            return this.addBean(bean.getClass()).setInstance(bean).build();
        }

        public BeanBag build() {
            return new BeanBag(this);
        }
    }
}

