/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.AbstractMultiTypeActionBuilder;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByQuery
extends AbstractAction {
    static final Logger log = LoggerFactory.getLogger(DeleteByQuery.class);

    public DeleteByQuery(Builder builder) {
        super(builder);
        this.setData(builder.query);
        this.setURI(this.buildURI());
    }

    @Override
    public String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_query");
        log.debug("Created URI for delete by query action is : {}", (Object)sb.toString());
        return sb.toString();
    }

    protected String createQueryString(LinkedHashSet<String> set) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String index : set) {
            sb.append(tmp);
            sb.append(index);
            tmp = ",";
        }
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    public String getRestMethodName() {
        return "DELETE";
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<DeleteByQuery, Builder> {
        private String query;

        public Builder(String query) {
            this.query = query;
        }

        @Override
        public DeleteByQuery build() {
            return new DeleteByQuery(this);
        }
    }
}

