/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.searchbox.AbstractAction;
import io.searchbox.BulkableAction;
import io.searchbox.params.Parameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bulk
extends AbstractAction {
    static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    private Gson gson = new Gson();

    public Bulk(Builder builder) {
        super(builder);
        this.indexName = builder.defaultIndex;
        this.typeName = builder.defaultType;
        this.setData(this.generateBulkPayload(builder.actions));
        this.setURI(this.buildURI());
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    protected Object generateBulkPayload(List<BulkableAction> actions) {
        StringBuilder sb = new StringBuilder();
        for (BulkableAction action : actions) {
            HashMap opMap = new HashMap(1);
            HashMap<String, String> opDetails = new HashMap<String, String>(3);
            if (StringUtils.isNotBlank((String)action.getIndex())) {
                opDetails.put("_index", action.getIndex());
            }
            if (StringUtils.isNotBlank((String)action.getType())) {
                opDetails.put("_type", action.getType());
            }
            if (StringUtils.isNotBlank((String)action.getId())) {
                opDetails.put("_id", action.getId());
            }
            for (String parameter : Parameters.ACCEPTED_IN_BULK) {
                try {
                    opDetails.put("_" + parameter, action.getParameter(parameter).toString());
                }
                catch (NullPointerException e) {
                    log.debug("Could not retrieve '" + parameter + "' parameter from action.", (Throwable)e);
                }
            }
            opMap.put(action.getBulkMethodName(), opDetails);
            sb.append(this.gson.toJson(opMap, new TypeToken<Map<String, Map<String, String>>>(){}.getType()));
            sb.append("\n");
            Object source = action.getData();
            if (source == null) continue;
            sb.append(this.getJson(source));
            sb.append("\n");
        }
        return sb.toString();
    }

    private Object getJson(Object source) {
        if (source instanceof String) {
            return StringUtils.deleteWhitespace((String)((String)source));
        }
        return this.gson.toJson(source);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder(super.buildURI());
        sb.append("/_bulk");
        return sb.toString();
    }

    public static class Builder
    extends AbstractAction.Builder<Bulk, Builder> {
        private List<BulkableAction> actions = new LinkedList<BulkableAction>();
        private String defaultIndex;
        private String defaultType;

        public Builder defaultIndex(String defaultIndex) {
            this.defaultIndex = defaultIndex;
            return this;
        }

        public Builder defaultType(String defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addAction(BulkableAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAction(Collection<? extends BulkableAction> actions) {
            this.actions.addAll(actions);
            return this;
        }

        @Override
        public Bulk build() {
            return new Bulk(this);
        }
    }
}

